/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui.keypad;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.keypad.KeypadListener;

public class VirtualKeypad2
extends JPanel {
    private Vector listeners = new Vector();
    private int fontSize;
    protected JTextField _number = new JTextField();
    private String valueS = "";
    private double value;
    private boolean enforceNumbers;
    protected Insets buttonMargin;
    protected Insets buttonInsets;
    protected int buttonFill;
    protected JButton decimal;
    protected JButton backspace;

    public String getValueS() {
        return this.valueS;
    }

    public void addKeypadListener(KeypadListener listener) {
        this.listeners.add(listener);
    }

    public VirtualKeypad2(int fontSize, boolean enforceNumbers) {
        this(fontSize, enforceNumbers, null, new Insets(0, 7, 7, 7), 1);
    }

    public VirtualKeypad2(int fontSize, boolean enforceNumbers, Insets buttonMargin, Insets buttonInsets, int buttonFill) {
        this.enforceNumbers = enforceNumbers;
        this.fontSize = fontSize;
        this.buttonMargin = buttonMargin;
        this.buttonInsets = buttonInsets;
        this.buttonFill = buttonFill;
        this.display(null);
    }

    public void setNumberEditable(boolean editable) {
        this._number.setEditable(editable);
    }

    protected void initButtons() {
        this._number.setEditable(false);
        this._number.setFont(new Font(null, 1, this.fontSize + 2));
        this._number.setForeground(Color.RED);
        this._number.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyChar() >= '0' && e.getKeyChar() <= '9' || e.getKeyChar() == '.' && (!VirtualKeypad2.this.valueS.contains(".") || !VirtualKeypad2.this.enforceNumbers)) {
                    VirtualKeypad2.this.valueS = VirtualKeypad2.this.valueS + String.valueOf(e.getKeyChar());
                }
                if (e.getKeyCode() == 8) {
                    int maxSize = Math.max(0, VirtualKeypad2.this.valueS.length() - 1);
                    VirtualKeypad2.this.valueS = VirtualKeypad2.this.valueS.substring(0, maxSize);
                }
                if (e.getKeyCode() == 10) {
                    VirtualKeypad2.this.enterPressed();
                } else {
                    VirtualKeypad2.this.updateValue();
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this._number.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                VirtualKeypad2.this.reset();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.decimal = new JButton(".");
        this.decimal.setFont(new Font(null, 1, this.fontSize + 2));
        this.decimal.setForeground(Color.RED);
        this.decimal.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualKeypad2.this.decimalPressed();
            }
        });
        this.decimal.setFocusable(false);
        this.decimal.setMargin(this.buttonMargin);
        this.backspace = new JButton("<-");
        this.backspace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VirtualKeypad2.this.backspace();
            }
        });
        this.backspace.setForeground(Color.RED);
        this.backspace.setFont(new Font(null, 1, this.fontSize + 2));
        this.backspace.setFocusable(false);
        this.backspace.setMargin(this.buttonMargin);
    }

    protected void display(String border) {
        this.initButtons();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        if (border != null) {
            this.setBorder(new TitledBorder(border));
        }
        c.fill = this.buttonFill;
        c.anchor = 10;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.insets = this.buttonInsets;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        this.add((Component)this._number, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)this.buildDigitButton(7), c);
        c.gridx = 1;
        this.add((Component)this.buildDigitButton(8), c);
        c.gridx = 2;
        this.add((Component)this.buildDigitButton(9), c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)this.buildDigitButton(4), c);
        c.gridx = 1;
        this.add((Component)this.buildDigitButton(5), c);
        c.gridx = 2;
        this.add((Component)this.buildDigitButton(6), c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)this.buildDigitButton(1), c);
        c.gridx = 1;
        this.add((Component)this.buildDigitButton(2), c);
        c.gridx = 2;
        this.add((Component)this.buildDigitButton(3), c);
        ++c.gridy;
        c.gridx = 0;
        this.add((Component)this.decimal, c);
        c.gridx = 1;
        this.add((Component)this.buildDigitButton(0), c);
        c.gridx = 2;
        this.add((Component)this.backspace, c);
    }

    protected JButton buildDigitButton(int digit) {
        JButton btn = new JButton("" + digit);
        btn.setFont(new Font(null, 0, this.fontSize));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                try {
                    int digit = Integer.parseInt(cmd);
                    VirtualKeypad2.this.digitPressed(digit);
                }
                catch (NumberFormatException e1) {
                    Logger.logException(this, (Exception)e1);
                }
            }
        });
        btn.setFocusable(false);
        btn.setMargin(this.buttonMargin);
        return btn;
    }

    private void decimalPressed() {
        if (!this.valueS.contains(".") || !this.enforceNumbers) {
            this.valueS = this.valueS + ".";
        }
        this.updateValue();
        for (KeypadListener element : this.listeners) {
            element.decimalPressed();
        }
    }

    private void backspace() {
        if (this.valueS.length() > 0) {
            this.valueS = this.valueS.substring(0, this.valueS.length() - 1);
            this.updateValue();
            for (KeypadListener element : this.listeners) {
                element.backspace();
            }
        }
    }

    private void digitPressed(int digit) {
        this.valueS = this.valueS + digit;
        this.updateValue();
        for (KeypadListener element : this.listeners) {
            element.keypadPressed(digit);
        }
    }

    private void enterPressed() {
        for (KeypadListener element : this.listeners) {
            element.enterPressed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateValue() {
        try {
            this.value = Utils.parseDouble(this.valueS);
        }
        catch (NumberFormatException e) {
            if (this.enforceNumbers) {
                this.value = 0.0;
                this.valueS = "";
            }
        }
        finally {
            this._number.setText(this.valueS);
        }
    }

    public void setNumber(double f) {
        this.valueS = Utils.getString3Decimals(f);
        this.updateValue();
    }

    public void reset() {
        this.valueS = "";
        this.updateValue();
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public void requestFocus() {
        this._number.requestFocus();
    }
}

