/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui.selector;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.selector.DataProvider;
import ro.atreides.utils.gui.selector.SelectorData;
import ro.atreides.utils.multilang.LangRoAll;

public class Selector
extends JPanel {
    private DataProvider dp;
    private int currentLevel;
    private JPanel topPanel;
    private JPanel bottomPanel;
    private GridBagConstraints topConstraints;
    private JButton start;
    private int fontSize;
    private int itemsPerLine;
    private int linesPerPage;
    private int currentPage = 0;
    private int maxPages = 0;
    private boolean showStartButton;
    private Vector currentData;
    private boolean clickMadeInCurrentPage;
    private boolean html;

    public Selector(DataProvider dp, int fontSize, boolean showStartButton, int itemsPerLine, int linesPerPage, boolean html) {
        this.dp = dp;
        this.fontSize = fontSize;
        this.showStartButton = showStartButton;
        this.itemsPerLine = itemsPerLine;
        this.linesPerPage = linesPerPage;
        this.html = html;
        this.display();
    }

    private void display() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 11;
        c.insets = new Insets(0, 0, 0, 0);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        this.topPanel = this.getTopPanel();
        this.add((Component)this.topPanel, c);
        c.gridwidth = 1;
        ++c.gridy;
        c.weighty = 0.0;
        c.weightx = 0.0;
        c.gridx = 0;
        c.fill = 3;
        JButton prev = new JButton("<<");
        prev.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Selector.this.prevPage();
            }
        });
        this.add((Component)prev, c);
        ++c.gridx;
        c.weightx = 1.0;
        c.fill = 1;
        this.bottomPanel = new JPanel(new GridBagLayout());
        this.setCurrentLevel(0);
        this.add((Component)this.bottomPanel, c);
        ++c.gridx;
        c.weightx = 0.0;
        c.fill = 3;
        JButton next = new JButton(">>");
        next.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                Selector.this.nextPage();
            }
        });
        this.add((Component)next, c);
        c.fill = 1;
        ++c.gridy;
        c.gridx = 0;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 3;
        JPanel space = new JPanel();
        this.add((Component)space, c);
        this.start.doClick();
    }

    private JPanel getTopPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.anchor = 11;
        c.insets = new Insets(2, 2, 2, 2);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridx = 0;
        this.start = new JButton(LangRoAll.start);
        this.start.setFont(new Font(null, 1, this.fontSize));
        this.start.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Selector.this.setCurrentLevel(0);
                Selector.this.removeNavigationButtons(Selector.this.getCurrentLevel());
                Selector.this.setBottomPanel(Selector.this.dp.getData(Selector.this.getCurrentLevel(), null), 0);
            }
        });
        if (this.showStartButton) {
            result.add((Component)this.start, c);
        }
        this.topConstraints = c;
        return result;
    }

    private void setBottomPanel(Vector data, int currentPage) {
        this.currentPage = currentPage;
        if (data == null) {
            return;
        }
        this.bottomPanel.removeAll();
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.anchor = 11;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridy = 0;
        c.gridx = 0;
        final int level = this.getCurrentLevel() + 1;
        int startAt = currentPage * this.linesPerPage * this.itemsPerLine;
        int stopAt = (currentPage + 1) * this.linesPerPage * this.itemsPerLine;
        for (int i = startAt; i < data.size() && i < stopAt; ++i) {
            final SelectorData current = (SelectorData)data.elementAt(i);
            String toString = this.html ? "<html><center>" + current.toString() + "</center></html>" : current.toString();
            JButton btn = new JButton(toString);
            btn.setFont(new Font(null, 1, this.fontSize));
            if (current.getColor() != null) {
                btn.setBackground(current.getColor());
                int reverseColor = GuiUtils.negateColor(current.getColor()).getRGB();
                btn.setForeground(new Color(reverseColor));
            }
            btn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Selector.this.setCurrentLevel(level);
                    Vector newData = Selector.this.dp.getData(level, current);
                    if (newData != null) {
                        Selector.this.addNavigationButton(level, current);
                    } else {
                        Selector.this.clickMadeInCurrentPage = true;
                    }
                    Selector.this.setBottomPanel(newData, 0);
                }
            });
            this.bottomPanel.add((Component)btn, c);
            ++c.gridx;
            if (c.gridx != this.itemsPerLine) continue;
            c.gridx = 0;
            ++c.gridy;
        }
        this.currentData = data;
        this.maxPages = (int)Math.ceil(this.currentData.size() / (this.itemsPerLine * this.linesPerPage));
        this.bottomPanel.setVisible(false);
        this.bottomPanel.setVisible(true);
    }

    private void addNavigationButton(final int level, final Object current) {
        ++this.topConstraints.gridx;
        JButton btn = new JButton("<html><center>" + current.toString() + "</center></html>");
        btn.setFont(new Font(null, 1, this.fontSize));
        btn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Selector.this.setCurrentLevel(level);
                Selector.this.removeNavigationButtons(level);
                Selector.this.currentData = Selector.this.dp.getData(level, current);
                Selector.this.setBottomPanel(Selector.this.currentData, 0);
                Selector.this.clickMadeInCurrentPage = false;
            }
        });
        this.topPanel.add((Component)btn, this.topConstraints);
        this.topPanel.setVisible(false);
        this.topPanel.setVisible(true);
    }

    private void removeNavigationButtons(int currentLevel) {
        int size = this.topPanel.getComponentCount();
        for (int i = currentLevel + 1; i < size; ++i) {
            int j = this.topPanel.getComponentCount() - 1;
            this.topPanel.remove(j);
        }
        this.topPanel.setVisible(false);
        this.topPanel.setVisible(true);
    }

    public void reset() {
        this.start.doClick();
        this.clickMadeInCurrentPage = false;
    }

    public void prevPage() {
        if (this.clickMadeInCurrentPage) {
            this.setCurrentLevel(this.getCurrentLevel() - 1);
            this.clickMadeInCurrentPage = false;
        }
        if (this.currentPage > 0) {
            this.setBottomPanel(this.currentData, this.currentPage - 1);
        }
    }

    public void nextPage() {
        if (this.clickMadeInCurrentPage) {
            this.setCurrentLevel(this.getCurrentLevel() - 1);
            this.clickMadeInCurrentPage = false;
        }
        if (this.currentPage < this.maxPages) {
            this.setBottomPanel(this.currentData, this.currentPage + 1);
        }
    }

    private int getCurrentLevel() {
        return this.currentLevel;
    }

    private void setCurrentLevel(int newLevel) {
        this.currentLevel = newLevel;
    }
}

