/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui.table;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.SortComparatorProvider;
import ro.atreides.utils.gui.table.SortOrder;
import ro.atreides.utils.gui.table.SortableHeaderRenderer;

public class SortableTable
extends JTable
implements SortOrder {
    private int _sortedColumn = -1;
    private boolean _ascending = true;
    private AbstractTM tm;
    private SortComparatorProvider sortProvider;

    public SortableTable(AbstractTM tableModel, SortComparatorProvider sortProvider) {
        super(tableModel);
        this.tm = tableModel;
        this.sortProvider = sortProvider;
        this.initComponents();
    }

    private final void initComponents() {
        this.getSelectionModel().setSelectionMode(0);
        JTableHeader header = this.getTableHeader();
        header.setDefaultRenderer(new SortableHeaderRenderer(this));
        header.setReorderingAllowed(false);
        header.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int columnIndex = SortableTable.this.getTableHeader().getColumnModel().getColumnIndexAtX(e.getX());
                if (e.getClickCount() == 1 && columnIndex != -1) {
                    SortableTable.this.sortByColumn(columnIndex);
                    SortableTable.this.getTableHeader().repaint();
                }
            }
        });
    }

    @Override
    public boolean isSortedByColumn(int columnIndex) {
        return this._sortedColumn == columnIndex;
    }

    @Override
    public boolean isSortedAscending() {
        return this._ascending;
    }

    @Override
    public void sortByColumn(int columnIndex) {
        if (columnIndex == this._sortedColumn) {
            this._ascending = !this._ascending;
        } else {
            this._sortedColumn = columnIndex;
            this._ascending = true;
        }
        Vector data = this.tm.getData();
        Comparator c = this.sortProvider.getComparatorForColumn(columnIndex);
        if (c != null) {
            Collections.sort(data, c);
            if (!this._ascending) {
                Collections.reverse(data);
            }
            this.tm.fireTableDataChanged();
        }
    }

    public void refresh(Vector newData) {
        this.tm.refresh(newData);
        this.resetSorting();
    }

    private void resetSorting() {
        this._sortedColumn = -1;
        this._ascending = true;
        this.getTableHeader().repaint();
    }
}

