/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.gui.xcombo;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Timer;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.event.ListDataEvent;
import ro.atreides.utils.gui.xcombo.FilterableComboBoxModel;
import ro.atreides.utils.gui.xcombo.StartsWithFilter;

public class XComboBox
extends JComboBox
implements KeyListener {
    private JTextField editorComp;
    private boolean processing = false;
    private StartsWithFilter filter;
    private boolean selectingItem = false;
    public static int xcomboSearchMinCharsGlobal = 0;
    public static boolean waitForEnter = false;
    public int xcomboSearchMinCharsLocal = -1;
    private long lastActionTime = Long.MAX_VALUE;
    private long typeMaxDelay = 1000L;
    private Timer timer = new Timer();

    public XComboBox(FilterableComboBoxModel model, boolean searchInProduct) {
        super(model);
        this.editorComp = (JTextField)this.getEditor().getEditorComponent();
        this.editorComp.addKeyListener(this);
        this.filter = new StartsWithFilter(searchInProduct);
        ((FilterableComboBoxModel)this.getModel()).setFilter(this.filter);
    }

    public XComboBox(FilterableComboBoxModel model) {
        super(model);
        this.editorComp = (JTextField)this.getEditor().getEditorComponent();
        this.editorComp.addKeyListener(this);
        this.filter = new StartsWithFilter(true);
        ((FilterableComboBoxModel)this.getModel()).setFilter(this.filter);
    }

    public void setComboName(String name) {
        this.editorComp.setName(name);
    }

    public void setXcomboSearchMinCharsLocal(int xcomboSearchMinCharsLocal) {
        this.xcomboSearchMinCharsLocal = xcomboSearchMinCharsLocal;
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    private synchronized void setProcessing(boolean processing) {
        this.processing = processing;
    }

    private synchronized boolean isProcessing() {
        return this.processing;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        String text = this.editorComp.getText();
        if (!e.isActionKey() && e.getKeyChar() != '\u001b' && e.getKeyChar() != '\b' && e.getKeyChar() != '\u007f') {
            boolean visible;
            boolean isEnter;
            this.setPopupVisible(false);
            boolean somethingTyped = text.length() > 0;
            int minSearch = xcomboSearchMinCharsGlobal;
            if (this.xcomboSearchMinCharsLocal >= 0) {
                minSearch = this.xcomboSearchMinCharsLocal;
            }
            boolean bl = isEnter = e.getKeyCode() == 10;
            if (text.length() >= minSearch) {
                this.filter.setFilterString(text);
                if (isEnter || !waitForEnter) {
                    this.setProcessing(true);
                    ((FilterableComboBoxModel)this.getModel()).applyFilters(text);
                    this.setProcessing(false);
                }
            }
            this.lastActionTime = System.currentTimeMillis();
            FilterableComboBoxModel model = (FilterableComboBoxModel)this.getModel();
            boolean hasElements = model.getSize() > 0;
            boolean singleResult = model.getSize() == 1;
            boolean bl2 = visible = (isEnter || !waitForEnter) && somethingTyped && hasElements;
            if (isEnter && somethingTyped && singleResult) {
                Object selected = model.getElementAt(0);
                this.setSelectedItem(selected);
                visible = false;
            }
            this.setPopupVisible(visible);
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void configureEditor(ComboBoxEditor anEditor, Object anItem) {
        if (!this.isProcessing()) {
            super.configureEditor(anEditor, anItem);
        }
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        Object oldSelection = this.selectedItemReminder;
        Object newSelection = this.dataModel.getSelectedItem();
        if (oldSelection == null || !oldSelection.equals(newSelection)) {
            this.selectedItemChanged();
            if (!this.selectingItem) {
                this.fireActionEvent();
            }
        }
    }

    @Override
    public void setSelectedItem(Object anObject) {
        super.setSelectedItem(anObject);
        if (anObject != null) {
            this.editorComp.setText(anObject.toString());
        } else {
            this.editorComp.setText("");
        }
    }

    public void clearAllText() {
        this.editorComp.setText("");
    }

    public void selectAllText() {
        this.editorComp.setSelectionStart(0);
        int stop = this.editorComp.getText().length();
        this.editorComp.setSelectionEnd(stop);
    }

    public void setText(String text) {
        this.editorComp.setText(text);
    }

    public String getText() {
        return this.editorComp.getText();
    }
}

