/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.licensing;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.security.MessageDigest;
import java.text.ParseException;
import java.util.Date;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.utils.DateUtils;
import ro.atreides.utils.Formatters;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.licensing.DiskIdBean;

public class LicenseVerifier {
    public static String getAppIdentifier(int idApp) {
        try {
            return LicenseVerifier.getHddID() + Utils.getStringMaxSize(2, "" + idApp, new Character('0'), true);
        }
        catch (IOException e) {
            Logger.logException("LicenseVerifier", (Exception)e);
            return null;
        }
    }

    public static boolean isLicensed(String license, int appId) {
        try {
            String hddID = LicenseVerifier.getAppIdentifier(appId);
            if (hddID == null || hddID.length() < 1) {
                return false;
            }
            MessageDigest encryptor = MessageDigest.getInstance("SHA1");
            hddID = hddID + "d1hfu53j4h5jhg4asb5ndhjkdf8hgj2dfhg7k345";
            encryptor.update(hddID.getBytes());
            byte[] key = encryptor.digest();
            StringBuffer hex = new StringBuffer(key.length);
            for (int i = 0; i < key.length; ++i) {
                byte b = key[i];
                hex.append(Integer.toHexString(0xFF & b));
            }
            if (hex.toString().equalsIgnoreCase(license)) {
                return true;
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String computeChecksum(String allLicenceStrings) {
        try {
            if (allLicenceStrings == null || allLicenceStrings.length() < 1) {
                return null;
            }
            MessageDigest encryptor = MessageDigest.getInstance("SHA1");
            allLicenceStrings = allLicenceStrings + "jkdf8hgj2dfhg7k345d1hfu53j4h5jhg4asb5ndh";
            encryptor.update(allLicenceStrings.getBytes());
            byte[] key = encryptor.digest();
            StringBuffer hex = new StringBuffer(key.length);
            for (int i = 0; i < key.length; ++i) {
                byte b = key[i];
                hex.append(Integer.toHexString(0xFF & b));
            }
            return hex.toString();
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getHddID() throws IOException {
        String osname = System.getProperty("os.name");
        osname = osname.toLowerCase();
        System.out.println("osname : " + osname);
        if (osname.startsWith("linux")) {
            String hddId = LicenseVerifier.getHddID_cid_linux();
            System.out.println("sdcard hddId : " + hddId);
            if (!Validators.correctString(hddId)) {
                hddId = LicenseVerifier.getHddID_scsiinfo();
                System.out.println("scsi hddId : " + hddId);
                if (!Validators.correctString(hddId)) {
                    hddId = LicenseVerifier.getHddID_hdparm();
                    System.out.println("hdparm hddId : " + hddId);
                }
            }
            return hddId;
        }
        if (osname.startsWith("windows")) {
            String hddId = LicenseVerifier.getHddID_diskid();
            System.out.println("diskid hddId : " + hddId);
            if (!Validators.correctString(hddId)) {
                hddId = LicenseVerifier.getHddID_vol();
                System.out.println("win hddId : " + hddId);
            }
            return hddId;
        }
        if (osname.startsWith("mac")) {
            String hddId = LicenseVerifier.getHddID_mac();
            System.out.println("mac Hdd id : " + hddId);
            return hddId;
        }
        return null;
    }

    protected static String getHddID_cid_linux() throws IOException {
        File f = new File("/bin/cat");
        long l = f.length();
        if (l <= 20000L) {
            return null;
        }
        int i = 0;
        String cmd = "/bin/cat /sys/block/mmcblk0/device/cid";
        String[] lines = LicenseVerifier.execute(cmd).split("\n");
        if (i < lines.length) {
            String line = lines[i];
            System.out.println("line: " + lines[i]);
            return line;
        }
        return null;
    }

    protected static String getHddID_mac() throws IOException {
        String result = null;
        try {
            InputStream is = LicenseVerifier.executeGrabOutput(System.getProperty("user.dir"), "/usr/sbin/system_profiler", "SPSerialATADataType");
            LineNumberReader reader = new LineNumberReader(new InputStreamReader(is));
            String line = reader.readLine();
            boolean foundCapacity = false;
            while (line != null) {
                line = line.trim();
                String s1 = "Line : " + line;
                Logger.logDebug(LicenseVerifier.class.getName(), s1);
                if (line.startsWith("Capacity")) {
                    foundCapacity = true;
                    String s2 = "Found Capacity !!";
                    Logger.logDebug(LicenseVerifier.class.getName(), s2);
                }
                if (foundCapacity && line.startsWith("Serial Number:")) {
                    Vector tokens = Utils.splitString(line, ':');
                    result = ((String)tokens.get(1)).trim();
                    String s3 = "Found serial number: " + result;
                    Logger.logDebug(LicenseVerifier.class.getName(), s3);
                    break;
                }
                line = reader.readLine();
            }
        }
        catch (Throwable throwable) {
            Logger.logError((Object)"getHddId_mac", throwable);
        }
        return result;
    }

    protected static String getHddID_hdparm() throws IOException {
        int i;
        String device = LicenseVerifier.getRootDevice();
        if (device.length() < 1) {
            return null;
        }
        if (device.startsWith("/dev/md")) {
            String[] lines1 = LicenseVerifier.execute("/sbin/mdadm --detail " + device).split("\n");
            for (i = 0; i < lines1.length; ++i) {
                Vector items;
                if (!lines1[i].contains("/sd") || (items = Utils.splitString(lines1[i], ' ')).size() <= 0) continue;
                device = (String)items.get(items.size() - 1);
                break;
            }
        }
        String[] lines = LicenseVerifier.execute("hdparm -I " + device).split("\n");
        for (i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!line.contains("Serial Number:")) continue;
            int startIndex = line.indexOf(58) + 1;
            int endIndex = line.length();
            String s = line.substring(startIndex, endIndex);
            s = s.trim();
            return s;
        }
        return null;
    }

    protected static String getHddID_scsiinfo() throws IOException {
        String device = LicenseVerifier.getRootDevice();
        if (device.length() < 1) {
            return null;
        }
        if (device.startsWith("/dev/md") || device.startsWith("/dev/mapper/")) {
            String s = "/sbin/mdadm --detail " + device;
            try {
                String[] lines1 = LicenseVerifier.execute(s).split("\n");
                for (int i = 0; i < lines1.length; ++i) {
                    Vector items;
                    if (!lines1[i].contains("/sd") || (items = Utils.splitString(lines1[i], ' ')).size() <= 0) continue;
                    device = (String)items.get(items.size() - 1);
                }
            }
            catch (IOException e) {
                device = "/dev/sda";
            }
        } else {
            System.out.println("device not raid");
        }
        File f = new File("/sbin/scsiinfo");
        long l = f.length();
        if (l <= 20000L) {
            return null;
        }
        String cmd = "/sbin/scsiinfo -s " + device;
        String[] lines = LicenseVerifier.execute(cmd).split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (!line.startsWith("Serial Number")) continue;
            int startIndex = line.indexOf(39) + 1;
            int endIndex = line.lastIndexOf(39);
            String s1 = line.substring(startIndex, endIndex).trim();
            return s1;
        }
        return null;
    }

    protected static String getHddID_vol() throws IOException {
        String currentDir = System.getProperty("user.dir");
        String device = currentDir.substring(0, currentDir.indexOf(58) + 1);
        String[] lines = LicenseVerifier.execute("cmd /c vol " + device).split("\n");
        String key = "Volume Serial Number is";
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            int index = line.indexOf(key);
            if (index <= -1) continue;
            return line.substring(index + key.length(), line.length()).trim();
        }
        return null;
    }

    protected static String getHddID_diskid() throws IOException {
        String currentDir = System.getProperty("user.dir");
        Hashtable<String, DiskIdBean> drives = new Hashtable<String, DiskIdBean>();
        String key1Line1 = "Drive Model Number";
        String key1Line2 = "Drive Serial Number";
        String key2Line1 = "Volume Serial Number is";
        String key2Line2 = "Serial Number";
        String driveModel = "";
        String driveSerial = "";
        boolean insideType1 = false;
        boolean insideType2 = false;
        try {
            InputStream inputStream = LicenseVerifier.executeGrabOutput(currentDir, "diskid32.exe");
            LineNumberReader lineNumberReader = new LineNumberReader(new InputStreamReader(inputStream));
            String line = lineNumberReader.readLine();
            while (line != null) {
                System.out.println("diskid: " + line);
                if (line.startsWith(key1Line1)) {
                    driveModel = LicenseVerifier.getWithinBrackets(line);
                    insideType1 = true;
                } else if (line.startsWith(key2Line1)) {
                    driveModel = LicenseVerifier.getWithinBrackets(line);
                    insideType2 = true;
                } else if (insideType1) {
                    if (line.startsWith(key1Line2)) {
                        driveSerial = LicenseVerifier.getWithinBrackets(line);
                        LicenseVerifier.addDiskIdBean(driveModel, driveSerial, drives);
                        driveModel = "";
                        driveSerial = "";
                        insideType1 = false;
                    } else {
                        System.out.println("diskid : was expecting " + key1Line2);
                    }
                } else if (insideType2) {
                    if (line.startsWith(key2Line2)) {
                        driveSerial = LicenseVerifier.getWithinBrackets(line);
                        LicenseVerifier.addDiskIdBean(driveModel, driveSerial, drives);
                        driveModel = "";
                        driveSerial = "";
                        insideType2 = false;
                    } else {
                        System.out.println("diskid : was expecting " + key2Line2);
                    }
                }
                line = lineNumberReader.readLine();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        if (drives.size() > 0) {
            String result = "";
            for (String key : drives.keySet()) {
                result = result + key + " ";
            }
            result = result.trim();
            return result;
        }
        return null;
    }

    private static void addDiskIdBean(String driveModel, String driveSerial, Hashtable<String, DiskIdBean> drives) {
        DiskIdBean bean = new DiskIdBean();
        driveModel = driveModel.replaceAll(" ", "-");
        driveModel = driveModel.toLowerCase();
        driveSerial = driveSerial.replaceAll(" ", "-");
        driveSerial = driveSerial.toLowerCase();
        String key = driveModel + "_" + driveSerial;
        System.out.println("diskid : Key= " + key);
        bean.setModel(driveModel);
        bean.setSerial(driveSerial);
        drives.put(key, bean);
    }

    private static String getWithinBrackets(String line) {
        int start = line.lastIndexOf("[");
        int end = line.indexOf("]", start);
        String result = "";
        if (end > start) {
            result = line.substring(start + 1, end).trim();
        }
        return result;
    }

    protected static String getRootDevice() throws IOException {
        String[] lines = LicenseVerifier.execute("df -TP /").split("\n");
        for (int i = 0; i < lines.length; ++i) {
            StringTokenizer tokenizer;
            System.out.println("line: " + lines[i]);
            String line = lines[i];
            if (!line.endsWith("/") || !(tokenizer = new StringTokenizer(line)).hasMoreTokens()) continue;
            return tokenizer.nextToken();
        }
        return null;
    }

    public static String execute(String command) throws IOException {
        String line;
        StringBuffer buffer = new StringBuffer();
        Runtime rtime = Runtime.getRuntime();
        Process s = rtime.exec(command);
        BufferedReader in = new BufferedReader(new InputStreamReader(s.getInputStream()));
        while ((line = in.readLine()) != null) {
            buffer.append(line);
            buffer.append("\n");
        }
        in.close();
        return buffer.toString();
    }

    public static InputStream executeGrabOutput(String directory, String ... exec) throws Throwable {
        File dir = new File(directory);
        String debugLine = "Execut \"" + exec + "\" din directorul \"" + dir.getAbsolutePath() + "\"";
        System.out.println(debugLine);
        ProcessBuilder pb = new ProcessBuilder(new String[0]);
        pb.directory(dir);
        pb.command(exec);
        pb.redirectErrorStream(true);
        Process onlineProcess = pb.start();
        return onlineProcess.getInputStream();
    }

    public static boolean verifyChecksum(String xmlLicenseFile, final StringBuffer sequenceSB) {
        try {
            SAXParser r = new SAXParser();
            final StringBuffer sb = new StringBuffer();
            final StringBuffer declaredChecksumSB = new StringBuffer();
            DefaultHandler handler = new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    String value;
                    String name;
                    if (qName.equalsIgnoreCase("license")) {
                        int seq;
                        declaredChecksumSB.append(attributes.getValue("checksum"));
                        String sequence = attributes.getValue("sequence");
                        if (Validators.correctString(sequence) && (seq = Integer.parseInt(sequence)) > 0) {
                            sb.append(sequence);
                            sequenceSB.append(sequence);
                        }
                        String s1 = "generatedAt";
                        String generatedAt = attributes.getValue(s1);
                        sb.append(generatedAt);
                        try {
                            Date d1 = Formatters.DATE_AND_TIME_FORMAT.parse(generatedAt);
                            if (!d1.before(new Date())) {
                                sb.append("1");
                                System.out.println("Data < data generare");
                            } else {
                                Date d2 = DateUtils.addDaysToDate(d1, 7);
                                if (d2.after(d2)) {
                                    System.out.println("Data curenta > data generare + 7");
                                    sb.append("1");
                                }
                            }
                        }
                        catch (ParseException e) {
                            Logger.logException(this, (Exception)e);
                            sb.append("1");
                            System.out.println("Data generare incorecta");
                        }
                    }
                    if (qName.equalsIgnoreCase("systemProperty")) {
                        name = attributes.getValue("name");
                        value = attributes.getValue("value");
                        sb.append(name + value);
                    }
                    if (qName.equalsIgnoreCase("clientProperty")) {
                        name = attributes.getValue("name");
                        value = attributes.getValue("value");
                        sb.append(name + value);
                    }
                    if (qName.equalsIgnoreCase("app")) {
                        name = attributes.getValue("name");
                        value = attributes.getValue("days");
                        sb.append(name + value);
                    }
                    if (qName.equalsIgnoreCase("module")) {
                        name = attributes.getValue("name");
                        value = attributes.getValue("days");
                        String classname = attributes.getValue("classname");
                        sb.append(name + value + classname);
                    }
                    if (qName.equalsIgnoreCase("client")) {
                        name = attributes.getValue("name");
                        value = attributes.getValue("days");
                        sb.append(name + value);
                    }
                }
            };
            r.setContentHandler(handler);
            r.setErrorHandler(handler);
            r.parse(xmlLicenseFile);
            String computedChecksum = LicenseVerifier.computeChecksum(sb.toString());
            String declaredChecksum = declaredChecksumSB.toString();
            return computedChecksum.equals(declaredChecksum);
        }
        catch (IOException e) {
            Logger.logException(Class.class.getName(), (Exception)e);
        }
        catch (SAXException e) {
            Logger.logException(Class.class.getName(), (Exception)e);
        }
        return false;
    }
}

