/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.licensing;

import java.io.IOException;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.deversoft.licensing.LicensingBean;
import ro.deversoft.licensing.LicensingInterface;

public class LicensingXmlHandler
extends DefaultHandler
implements LicensingInterface {
    private Vector<LicensingBean> applications = new Vector();
    private Vector<LicensingBean> modules = new Vector();
    private Vector<LicensingBean> systemProperties = new Vector();
    private Vector<LicensingBean> clientProperties = new Vector();
    private String generatedAt;
    private String licenceFileId = "";
    private String sequence = "";
    private String checksum = "";
    private Integer majorVersion = null;

    @Override
    public String getGeneratedAt() {
        return this.generatedAt;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        LicensingBean bean;
        String attrValue;
        String attrName;
        if (qName.equalsIgnoreCase("license")) {
            this.generatedAt = attributes.getValue("generatedAt");
            this.licenceFileId = attributes.getValue("clientName");
            this.sequence = attributes.getValue("sequence");
            this.checksum = attributes.getValue("checksum");
            String majorVersionS = attributes.getValue("mainVersion");
            if (Validators.correctInteger(majorVersionS)) {
                this.majorVersion = Integer.parseInt(majorVersionS);
            }
        }
        if (qName.equalsIgnoreCase("clientProperty")) {
            attrName = attributes.getValue("name");
            attrValue = attributes.getValue("value");
            bean = new LicensingBean();
            bean.setName(attrName);
            bean.setValue(attrValue);
            this.clientProperties.add(bean);
        }
        if (qName.equalsIgnoreCase("systemProperty")) {
            attrName = attributes.getValue("name");
            attrValue = attributes.getValue("value");
            bean = new LicensingBean();
            bean.setName(attrName);
            bean.setValue(attrValue);
            this.systemProperties.add(bean);
        }
        if (qName.equalsIgnoreCase("app")) {
            attrName = attributes.getValue("name");
            attrValue = attributes.getValue("days");
            bean = new LicensingBean();
            bean.setName(attrName);
            bean.setValue(attrValue);
            this.applications.add(bean);
        }
        if (qName.equalsIgnoreCase("module")) {
            attrName = attributes.getValue("classname");
            attrValue = attributes.getValue("days");
            bean = new LicensingBean();
            bean.setName(attrName);
            bean.setValue(attrValue);
            this.modules.add(bean);
        }
    }

    @Override
    public String getChecksum() {
        return this.checksum;
    }

    @Override
    public String getSequence() {
        return this.sequence;
    }

    @Override
    public String getLicenceFileId() {
        return this.licenceFileId;
    }

    @Override
    public Integer getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public void load(String filepath) throws IOException {
        try {
            Utils.importXml((DefaultHandler)this, filepath);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Vector<LicensingBean> getApplications() {
        return this.applications;
    }

    @Override
    public Vector<LicensingBean> getModules() {
        return this.modules;
    }

    @Override
    public Vector<LicensingBean> getSystemProperties() {
        return this.systemProperties;
    }

    @Override
    public Vector<LicensingBean> getClientProperties() {
        return this.clientProperties;
    }
}

