/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.plati.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.plati.TipPlata;

public class TipPlataDao
implements DaoInterface {
    private Connection connection;
    private PreparedStatement getAllTipPlata;
    private PreparedStatement selectById;
    private PreparedStatement addTipPlata;
    private PreparedStatement updateTipPlata;
    private PreparedStatement deleteTipPlata;
    private PreparedStatement clearDefault;
    private PreparedStatement setDefault;
    private PreparedStatement getDefault;
    private PreparedStatement selectByCodCasa;
    private PreparedStatement selectByName;

    public TipPlataDao(Connection connection) throws SQLException {
        this.connection = connection;
        this.buildPreparedStatements();
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        String s = "select id,name,map_ecr,is_default,request_comment,request_password, coalesce(tip_cont,-1) as cont,coalesce(id_promo,-1) as promo, document_de_plata from tip_plata";
        this.getAllTipPlata = this.connection.prepareStatement(s + " where status = " + 1 + " order by name");
        this.getDefault = this.connection.prepareStatement(s + " where status = " + 1 + " and is_default = 1");
        this.selectById = this.connection.prepareStatement(s + " where id = ?");
        this.selectByCodCasa = this.connection.prepareStatement(s + " where map_ecr = ?");
        this.selectByName = this.connection.prepareStatement(s + " where status = " + 1 + " and name = ?");
        this.addTipPlata = this.connection.prepareStatement("insert into tip_plata ( name, map_ecr, is_default, tip_cont, id_promo, request_comment, request_password, document_de_plata ) values ( ? , ? , ? , ? , ?, ?, ?, ? )");
        this.updateTipPlata = this.connection.prepareStatement("update tip_plata set name = ?, map_ecr = ?, is_default = ?, tip_cont = ?, id_promo = ?, request_comment = ?, request_password = ?, document_de_plata = ? where id = ?");
        this.deleteTipPlata = this.connection.prepareStatement("update tip_plata set status = 2 where id = ?");
        this.clearDefault = this.connection.prepareStatement("update tip_plata set is_default = 0");
        this.setDefault = this.connection.prepareStatement("update tip_plata set is_default = 1 where id = ?");
    }

    public void setDefault(int id) throws SQLException {
        this.setDefault.setInt(1, id);
        this.setDefault.execute();
    }

    public void clearDefault() throws SQLException {
        this.clearDefault.execute();
    }

    public TipPlata getDefaultTipPlata() throws SQLException {
        TipPlata result = null;
        ResultSet rs = this.getDefault.executeQuery();
        if (rs.next()) {
            result = TipPlataDao.getFromRs(rs);
        }
        rs.close();
        return result;
    }

    public void deleteTipPlata(int id) throws SQLException {
        this.deleteTipPlata.setInt(1, id);
        this.deleteTipPlata.execute();
    }

    public void updateTipPlata(String nume, String ecr, boolean isDefault, int cont, int promo, boolean requestComment, boolean requestPassword, boolean documentDePlata, int id) throws SQLException {
        this.updateTipPlata.setString(1, nume);
        this.updateTipPlata.setString(2, ecr);
        this.updateTipPlata.setInt(3, isDefault ? 1 : 0);
        if (cont == -1) {
            this.updateTipPlata.setNull(4, 4);
        } else {
            this.updateTipPlata.setInt(4, cont);
        }
        if (promo == -1) {
            this.updateTipPlata.setNull(5, 4);
        } else {
            this.updateTipPlata.setInt(5, promo);
        }
        this.updateTipPlata.setInt(6, requestComment ? 1 : 0);
        this.updateTipPlata.setInt(7, requestPassword ? 1 : 0);
        this.updateTipPlata.setInt(8, documentDePlata ? 1 : 0);
        this.updateTipPlata.setInt(9, id);
        this.updateTipPlata.execute();
    }

    public void addTipPlata(String nume, String ecr, boolean isDefault, int cont, int promo, boolean requestComment, boolean requestPassword, boolean documentDePlata) throws SQLException {
        this.addTipPlata.setString(1, nume);
        this.addTipPlata.setString(2, ecr);
        this.addTipPlata.setInt(3, isDefault ? 1 : 0);
        if (cont == -1) {
            this.addTipPlata.setNull(4, 4);
        } else {
            this.addTipPlata.setInt(4, cont);
        }
        if (promo == -1) {
            this.addTipPlata.setNull(5, 4);
        } else {
            this.addTipPlata.setInt(5, promo);
        }
        this.addTipPlata.setInt(6, requestComment ? 1 : 0);
        this.addTipPlata.setInt(7, requestPassword ? 1 : 0);
        this.addTipPlata.setInt(8, documentDePlata ? 1 : 0);
        this.addTipPlata.execute();
    }

    public Vector<TipPlata> getAllTipPlata() throws SQLException {
        Vector<TipPlata> result = new Vector<TipPlata>();
        ResultSet rs = this.getAllTipPlata.executeQuery();
        while (rs.next()) {
            TipPlata toAdd = TipPlataDao.getFromRs(rs);
            result.add(toAdd);
        }
        rs.close();
        return result;
    }

    public static TipPlata getFromRs(ResultSet rs) throws SQLException {
        int id = rs.getInt("id");
        String name = rs.getString("name");
        String ecr = rs.getString("map_ecr");
        boolean def = rs.getInt("is_default") == 1;
        int cont = rs.getInt("cont");
        int promo = rs.getInt("promo");
        boolean requestComment = rs.getInt("request_comment") == 1;
        boolean requestPassword = rs.getInt("request_password") == 1;
        boolean documentDePlata = rs.getInt("document_de_plata") == 1;
        TipPlata toAdd = new TipPlata(id, name, ecr, def, cont, promo, requestComment, requestPassword, documentDePlata);
        return toAdd;
    }

    public TipPlata getById(int id) throws SQLException {
        TipPlata p = null;
        this.selectById.setInt(1, id);
        ResultSet rs = this.selectById.executeQuery();
        if (rs.next()) {
            p = TipPlataDao.getFromRs(rs);
        }
        rs.close();
        return p;
    }

    public TipPlata getByCodCasa(String codCasa) throws SQLException {
        TipPlata p = null;
        this.selectByCodCasa.setString(1, codCasa);
        ResultSet rs = this.selectByCodCasa.executeQuery();
        if (rs.next()) {
            p = TipPlataDao.getFromRs(rs);
        }
        rs.close();
        return p;
    }

    public TipPlata getByName(String name) throws SQLException {
        TipPlata p = null;
        this.selectByName.setString(1, name);
        ResultSet rs = this.selectByName.executeQuery();
        if (rs.next()) {
            p = TipPlataDao.getFromRs(rs);
        }
        rs.close();
        return p;
    }
}

