/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.registre;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.utils.db.DaoInterface;
import ro.atreides.utils.registre.RegistruBean;
import ro.atreides.utils.sql.SqlUtils;

public class RegistreDao
implements DaoInterface {
    private PreparedStatement addRegistru;
    private PreparedStatement getRegistruByKey;
    private PreparedStatement addNumber;
    private PreparedStatement getLastNumberForRegistru;
    private PreparedStatement getAllRegistre;
    private PreparedStatement deleteNumbersForRegistru;
    private PreparedStatement getObservationsBonConsum;
    private PreparedStatement getObservationsTransfer;
    private Connection conn;

    public RegistreDao(Connection conn) throws SQLException {
        this.conn = conn;
        this.buildPreparedStatements();
    }

    public Connection getConn() {
        return this.conn;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.addRegistru = this.conn.prepareStatement("insert into registre_nomenclator ( nume_registru, uniquekey ) values ( ?, ?)");
        this.getRegistruByKey = this.conn.prepareStatement("select * from registre_nomenclator where uniquekey = ?");
        this.addNumber = this.conn.prepareStatement("insert into registre_numere ( id_registru, numar ) values ( ?, ? )");
        this.getLastNumberForRegistru = this.conn.prepareStatement("select max(numar) from registre_numere where id_registru = ?");
        this.getAllRegistre = this.conn.prepareStatement("select * from registre_nomenclator");
        this.deleteNumbersForRegistru = this.conn.prepareStatement("delete from registre_numere where id_registru = ?");
        this.getObservationsBonConsum = this.conn.prepareStatement("select observatii from bonuri_consum where nr_bon_consum = (select numar from registre_numere where id_registru=2 and id=?)");
    }

    public void deleteNumbersForRegistru(int idRegistru) throws SQLException {
        this.deleteNumbersForRegistru.setInt(1, idRegistru);
        this.deleteNumbersForRegistru.execute();
    }

    public int getMaxNrForRegistru(int idRegistru) throws SQLException {
        int result = 0;
        this.getLastNumberForRegistru.setInt(1, idRegistru);
        ResultSet rs = this.getLastNumberForRegistru.executeQuery();
        if (rs.next()) {
            result = rs.getInt(1);
        }
        rs.close();
        return result;
    }

    public void addRegistru(String key, String nume) throws SQLException {
        this.addRegistru.setString(1, nume);
        this.addRegistru.setString(2, key);
        this.addRegistru.execute();
    }

    public RegistruBean getRegistruByKey(String key) throws SQLException {
        RegistruBean result = null;
        this.getRegistruByKey.setString(1, key);
        ResultSet rs = this.getRegistruByKey.executeQuery();
        if (rs.next()) {
            result = this.getRegistruFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Vector<RegistruBean> getAllRegistre() throws SQLException {
        Vector<RegistruBean> result = new Vector<RegistruBean>();
        ResultSet rs = this.getAllRegistre.executeQuery();
        while (rs.next()) {
            RegistruBean toadd = this.getRegistruFromResultSet(rs);
            result.add(toadd);
        }
        rs.close();
        return result;
    }

    private RegistruBean getRegistruFromResultSet(ResultSet rs) throws SQLException {
        RegistruBean result = new RegistruBean();
        result.setKey(rs.getString("uniquekey"));
        result.setIdRegistru(rs.getInt("id"));
        result.setDescriere(rs.getString("nume_registru"));
        return result;
    }

    public void addNumber(int idRegistru, int numar) throws SQLException {
        this.addNumber.setInt(1, idRegistru);
        this.addNumber.setInt(2, numar);
        this.addNumber.execute();
    }

    public void lockNumbersTable() throws SQLException {
        String lockMode = "EXCLUSIVE";
        SqlUtils.executeUpdate("lock table registre_numere in " + lockMode + " MODE", this.conn);
    }

    public String getObservatiiBonConsumForRegister(int nrDoc) {
        String result = "";
        try {
            this.getObservationsBonConsum.setInt(1, nrDoc);
            ResultSet rs = this.getObservationsBonConsum.executeQuery();
            if (rs.next()) {
                result = rs.getString("observatii");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result == null ? "" : result;
    }
}

