/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.registre;

import java.sql.SQLException;
import ro.atreides.utils.Logger;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.registre.RegistreDao;
import ro.atreides.utils.registre.RegistruBean;

public class RegistreLogic {
    private static RegistreLogic instance = null;
    private ConnectionPool pool = ConnectionPool.getInstance();

    private RegistreLogic() {
    }

    public static synchronized RegistreLogic getInstance() {
        if (instance == null) {
            instance = new RegistreLogic();
        }
        return instance;
    }

    private synchronized RegistreDao getDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        RegistreDao dao = null;
        while (dao == null) {
            dao = (RegistreDao)this.pool.getDao(RegistreDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(RegistreDao.class.getName(), connection);
        }
        return dao;
    }

    public void addRegistruNoCommit(String key, String descriere) throws SQLException {
        this.getDao().addRegistru(key, descriere);
    }

    public RegistruBean getRegistruByKeyNoCommit(String key) throws SQLException {
        return this.getDao().getRegistruByKey(key);
    }

    public RegistruBean getOrAddRegistruNoCommit(String key, String descriere) throws SQLException {
        RegistruBean registruBean = null;
        for (int retries = 3; registruBean == null && retries > 0 && (registruBean = this.getRegistruByKeyNoCommit(key)) == null; --retries) {
            this.addRegistruNoCommit(key, descriere);
        }
        return registruBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int getNewNumberForRegistru(String key, String descriere, boolean increment) {
        int newNumber = -1;
        try {
            newNumber = this.getNewNumberForRegistruNoCommit(key, descriere, increment);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return newNumber;
    }

    public synchronized int getNewNumberForRegistruNoCommit(String key, String descriere, boolean increment) throws SQLException {
        return this.getNewNumberForRegistruNoCommit(key, descriere, increment, -1);
    }

    public synchronized int getNewNumberForRegistruNoCommit(String key, String descriere, boolean increment, int forcedNumber) throws SQLException {
        RegistruBean registruBean = this.getOrAddRegistruNoCommit(key, descriere);
        return this.getNewNumberNoCommit(registruBean, increment, forcedNumber);
    }

    private int getNewNumberNoCommit(RegistruBean registruBean, boolean increment, int forcedNumber) throws SQLException {
        this.getDao().lockNumbersTable();
        int newNumber = 0;
        if (forcedNumber > 0) {
            this.getDao().deleteNumbersForRegistru(registruBean.getIdRegistru());
            newNumber = forcedNumber;
            increment = true;
        } else {
            int lastNumber = this.getCurrentNrForRegistruNoCommit(registruBean);
            newNumber = lastNumber + 1;
        }
        if (increment) {
            this.getDao().addNumber(registruBean.getIdRegistru(), newNumber);
        }
        return newNumber;
    }

    public int getCurrentNrForRegistruNoCommit(RegistruBean registruBean) throws SQLException {
        return this.getDao().getMaxNrForRegistru(registruBean.getIdRegistru());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentNrForRegistru(String key, String descriere) {
        try {
            int result = this.getCurrentNrForRegistruNoCommit(this.getOrAddRegistruNoCommit(key, descriere));
            this.pool.commit();
            int n = result;
            return n;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e);
            }
            int n = -1;
            return n;
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public String getObservatiiBonConsumForNrDoc(int nrDoc) {
        return this.getDao().getObservatiiBonConsumForRegister(nrDoc);
    }
}

