/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.startup;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.sql.SQLException;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.Vector;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Utils;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.config.db.ConfigDao;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.multilanguage.Language;
import ro.atreides.utils.multilanguage.db.MultilangDao;
import ro.atreides.utils.sql.SqlUtils;

public class DbData {
    private ConnectionPool pool = ConnectionPool.getInstance();

    public DbData() throws SQLException, IOException {
        this.pool.buildDaos(ConfigDao.class.getName());
        this.pool.buildDaos(MultilangDao.class.getName());
        Config.getInstance();
        Logger.getInstance(5, "startup.log");
        this.buildMessages();
        this.buildConfigs();
        this.insertInitialData();
        this.pool.requestConnection().commitTransaction();
        this.pool.releaseConnection();
    }

    private synchronized ConfigDao getConfigDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        ConfigDao dao = (ConfigDao)this.pool.getDao(ConfigDao.class, connection);
        return dao;
    }

    private synchronized MultilangDao getMultilangDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        MultilangDao dao = (MultilangDao)this.pool.getDao(MultilangDao.class, connection);
        return dao;
    }

    public void insertInitialData() throws SQLException, IOException {
        File[] files = FileUtils.listFiles("startup", "db-", ".txt");
        for (int i = 0; i < files.length; ++i) {
            String name = files[i].getName();
            String table = name.substring(3, name.length() - 4);
            System.out.println("table : " + table);
            this.processInitialDataForFile(files[i], table);
        }
    }

    private void processInitialDataForFile(File file, String tableName) throws IOException, SQLException {
        LineNumberReader in = new LineNumberReader(new InputStreamReader(new FileInputStream(file)));
        String s = null;
        while ((s = in.readLine()) != null) {
            int i;
            Vector<String> columns = new Vector<String>();
            Vector<String> data = new Vector<String>();
            StringTokenizer token = new StringTokenizer(s, "|");
            String key = token.nextToken();
            int idKey = this.getMultilangDao().getIdForKey(key);
            if (idKey == -1) {
                System.out.println("Could not find key for : " + key + " . This is a fatal error, exiting !!");
                Utils.systemExit();
            }
            columns.add(new String("id_key"));
            data.add("" + idKey);
            while (token.hasMoreTokens()) {
                String entry = token.nextToken();
                StringTokenizer token2 = new StringTokenizer(entry, "=");
                String column = token2.nextToken();
                String value = token2.nextToken();
                columns.add(column);
                data.add(value);
            }
            if (columns.size() == 0) {
                return;
            }
            String insertString = "insert into " + tableName + " (";
            for (i = 0; i < columns.size() - 1; ++i) {
                insertString = insertString + " " + (String)columns.elementAt(i) + ", ";
            }
            insertString = insertString + " " + (String)columns.elementAt(columns.size() - 1) + " ) values ( ";
            for (i = 0; i < data.size() - 1; ++i) {
                Object elem = data.elementAt(i);
                insertString = insertString + " " + (String)elem + ",";
            }
            insertString = insertString + " " + (String)data.elementAt(data.size() - 1) + " )";
            System.out.println("Inserting : " + insertString);
            SqlUtils.executeUpdate(insertString, this.pool.requestConnection().getConnection());
        }
    }

    public void buildMessages() {
        try {
            Collection langs = this.getMultilangDao().getAllLanguages();
            for (Language element : langs) {
                String lang = element.getLangShort();
                int idLang = element.getId();
                try {
                    LineNumberReader in = new LineNumberReader(new InputStreamReader(new FileInputStream("startup/messages_" + lang + ".txt")));
                    String s = null;
                    while ((s = in.readLine()) != null) {
                        if (s.trim().length() == 0) continue;
                        StringTokenizer token = new StringTokenizer(s, "=");
                        String key = token.nextToken();
                        String label = token.nextToken();
                        int idKey = this.getMultilangDao().getIdForKey(key);
                        if (idKey == -1) {
                            this.getMultilangDao().addKey(key);
                            idKey = this.pool.requestConnection().getIndentityLocal();
                        }
                        this.getMultilangDao().addMessage(label, idKey, idLang);
                    }
                    this.pool.requestConnection().commitTransaction();
                    this.pool.releaseConnection();
                }
                catch (IOException e) {
                    Logger.logException(this, (Exception)e);
                }
                catch (SQLException e) {
                    Logger.logException(this, (Exception)e);
                }
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
    }

    private void buildConfigs() {
        try {
            LineNumberReader in = new LineNumberReader(new InputStreamReader(new FileInputStream("startup/configs.txt")));
            String s = null;
            while ((s = in.readLine()) != null) {
                int idConfig;
                if (s.trim().equals("") || s.startsWith("#")) continue;
                StringTokenizer token = new StringTokenizer(s, "|");
                String key = token.nextToken();
                String defaultValue = token.nextToken();
                int visible = Integer.parseInt(token.nextToken());
                int idKey = this.getMultilangDao().getIdForKey(key);
                if (idKey == -1) {
                    this.getMultilangDao().addKey(key);
                    idKey = this.pool.requestConnection().getIndentityLocal();
                }
                if ((idConfig = this.getConfigDao().getIdConfigByKeyId(idKey)) == -1) {
                    this.getConfigDao().addConfig(idKey, defaultValue, visible);
                    continue;
                }
                this.getConfigDao().updateConfig(idConfig, defaultValue);
            }
            this.pool.requestConnection().commitTransaction();
            this.pool.releaseConnection();
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        catch (NumberFormatException e) {
            Logger.logException(this, (Exception)e);
        }
    }
}

