/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.tags.gui;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import net.miginfocom.swing.MigLayout;
import ro.atreides.stocks.Stock;
import ro.atreides.utils.gui.ComboUtils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.tags.Tag;
import ro.atreides.utils.tags.TagsLogic;

public class TagsMiniPanel
extends JPanel {
    private JButton adauga;
    private JTable table;
    private DefaultTableModel model;
    private Vector<Tag> data = new Vector();
    private Integer idStock = -1;
    private JComboBox<Tag> tagsCombo;

    public TagsMiniPanel() {
        this.display();
    }

    public void setStock(Stock stock) {
        if (stock == null) {
            this.idStock = -1;
            this.data.clear();
        } else {
            this.idStock = stock.getId();
        }
        this.refreshTable();
    }

    public void display() {
        this.setLayout((LayoutManager)new MigLayout("insets 3", "grow"));
        this.setBorder(new TitledBorder(LangRoAll.tags));
        this.adauga = new JButton("Adauga tag");
        this.tagsCombo = new JComboBox<Tag>(TagsLogic.getInstance().getAllTags());
        this.add(this.tagsCombo, "growx");
        this.add((Component)this.adauga, "growx, wrap");
        this.model = new DefaultTableModel(){

            @Override
            public String getColumnName(int column) {
                return "Taguri";
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public int getRowCount() {
                return TagsMiniPanel.this.data.size();
            }

            @Override
            public Object getValueAt(int row, int column) {
                return TagsMiniPanel.this.data.get(row);
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.table = new JTable(this.model);
        JScrollPane scrollPane = new JScrollPane(this.table);
        this.add((Component)scrollPane, "span 3, grow");
        this.doStuff();
    }

    private void doStuff() {
        this.adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TagsMiniPanel.this.tagsCombo.getItemCount() > 0) {
                    Tag tag = (Tag)TagsMiniPanel.this.tagsCombo.getSelectedItem();
                    TagsMiniPanel.this.data.add(tag);
                    TagsMiniPanel.this.model.fireTableDataChanged();
                }
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                int selRow = TagsMiniPanel.this.table.rowAtPoint(e.getPoint());
                if (selRow != -1 && e.getClickCount() == 2 && DialogUtils.confirmDialog(GuiUtils.currentFrame, LangRoAll.tagStergem, LangRoAll.confirmare)) {
                    TagsMiniPanel.this.data.remove(selRow);
                    TagsMiniPanel.this.model.fireTableDataChanged();
                }
            }
        });
    }

    private boolean hasMaximumNumberOfTags() {
        boolean result = false;
        int MAXIMUM_NUMBER_OF_TAGS = 1;
        if (this.data.size() >= MAXIMUM_NUMBER_OF_TAGS) {
            result = true;
        }
        return result;
    }

    private void refreshTable() {
        if (this.idStock != -1) {
            this.data = TagsLogic.getInstance().getAllStocksTags(this.idStock);
            if (this.hasMaximumNumberOfTags()) {
                this.adauga.setEnabled(false);
            } else {
                this.adauga.setEnabled(true);
            }
        }
        this.model.fireTableDataChanged();
    }

    public Vector<Tag> getTagsToSave() {
        return this.data;
    }

    public void updateTags() {
        ComboUtils.replaceItemsForCombo(this.tagsCombo, TagsLogic.getInstance().getAllTags(), false);
    }
}

