/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.tracking;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import ro.atreides.utils.FileUtils;
import ro.atreides.utils.Logger;
import ro.atreides.utils.TextUtils;
import ro.atreides.utils.Utils;
import ro.atreides.utils.sql.SqlUtils;
import ro.atreides.utils.tracking.MultipartUtility;
import ro.atreides.utils.tracking.TrackingBean;

public class TrackingLogic {
    public static final String TRACKING_APP_START_DATE = "app_start_date";
    public static final String TRACKING_MODULE = "module";
    public static final String TRACKING_LICENSE_NAME = "license_name";
    public static final String TRACKING_LICENSE_SEQUENCE = "license_sequence";
    public static final String TRACKING_LICENSE_CHECKSUM = "license_checksum";
    public static final String TRACKING_THEFT = "theft";
    public static final String TRACKING_ERRORS = "errors";
    public static final String TRACKING_LICENSE_EXPIRY_APP = "license_expiry_app";
    public static final String TRACKING_LICENSE_EXPIRY_MODULE = "license_expiry_module";
    public static final String TRACKING_HDDID = "hddid";
    public static final String TRACKING_MAJOR_VERSION = "major_version";
    public static final String TRACKING_DB_KIND = "db_kind";
    public static final String TRACKING_DB_DERBY_TYPE = "db_derby_type";
    public static final String TRACKING_DB_HOST = "db_host";
    public static final String TRACKING_DB_PORT = "db_port";
    public static final String TRACKING_DB_NAME = "db_name";
    public static final String TRACKING_DB_BACKUPMINUTES = "db_backup_minutes";
    public static final String TRACKING_DB_BACKUP_START = "db_backup_start";
    public static final String TRACKING_DB_BACKUP_DONE = "db_backup_done";
    public static final String TRACKING_DB_BACKUP_FAILED = "db_backup_failed";
    public static final String TRACKING_SERIE_FISCALA = "seriefiscala";
    public static final String TRACKING_STATIE = "statie";
    public static final String TRACKING_PDA = "pda";
    public static final String TRACKING_ID_SOCIETATE = "societate";
    public static final String TRACKING_ID_ADDRESS = "adresa";
    public static final String TRACKING_ID_CUI = "cui";
    public static final String TRACKING_ID_SEDIU = "sediu";
    private static TrackingLogic instance;
    private Connection firstConnection;

    private TrackingLogic(Connection firConnection) {
        this.firstConnection = firConnection;
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                TrackingLogic.this.sendUnsentData();
            }
        });
    }

    public static synchronized TrackingLogic getFirstInstance(Connection firConnection) {
        instance = new TrackingLogic(firConnection);
        return instance;
    }

    public static synchronized TrackingLogic getInstance() {
        return instance;
    }

    public void addLicenseTracking(String type, String payload, String ips) {
        try {
            this.addLicenseTrackingNoCommit(type, payload, ips);
        }
        catch (SQLException e) {
            try {
                this.firstConnection.rollback();
            }
            catch (SQLException e1) {
                Logger.logError((Object)this, e1);
            }
            this.rebuildTables();
        }
    }

    public void addLicenseTrackingNoCommit(String type, String payload, String ips) throws SQLException {
        SqlUtils.executeInsert("insert into tracking_log(type, payload, device_ips) values ('" + type + "','" + payload + "','" + ips + "')", this.firstConnection);
        this.firstConnection.commit();
    }

    private void rebuildTables() {
        String dropTable = "drop table tracking_log";
        try {
            SqlUtils.executeUpdate(dropTable, this.firstConnection);
            this.firstConnection.commit();
        }
        catch (SQLException e) {
            try {
                this.firstConnection.rollback();
            }
            catch (SQLException e1) {
                Logger.logError((Object)this, e1);
            }
        }
        String createTable = "create table tracking_log (id serial unique,dataora timestamp default CURRENT_TIMESTAMP,type varchar(200) NOT NULL default '',payload varchar(1000) NOT NULL default '',device_ips varchar(200) NOT NULL default '',status int not null default 1)";
        try {
            SqlUtils.executeUpdate(createTable, this.firstConnection);
            this.firstConnection.commit();
        }
        catch (SQLException e) {
            e.printStackTrace();
            Logger.logWarning(this, "DATABASE INTEGRITY VIOLATION. COULD NOT CREATE TABLE !!");
            Utils.systemExit();
        }
    }

    private String buildXmlContent() throws SQLException, IllegalAccessException {
        Vector<TrackingBean> toSend = new Vector<TrackingBean>();
        ResultSet rs = SqlUtils.executeQuery("select * from tracking_log", this.firstConnection);
        while (rs.next()) {
            TrackingBean tb = new TrackingBean();
            tb.setDateadd(rs.getTimestamp("dataora"));
            tb.setType(rs.getString("type"));
            tb.setPayload(rs.getString("payload"));
            tb.setIps(rs.getString("device_ips"));
            tb.setStatus(rs.getInt("status"));
            tb.setId(rs.getInt("id"));
            toSend.add(tb);
        }
        rs.close();
        if (toSend.size() <= 0) {
            return null;
        }
        StringBuffer bigFile = new StringBuffer();
        bigFile.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        bigFile.append("<document>\n");
        for (TrackingBean trackingBean : toSend) {
            TextUtils.dumpToXml(trackingBean, bigFile, "trackingbean", "");
        }
        bigFile.append("</document>");
        return bigFile.toString();
    }

    private boolean sendXmlFileToServer(String content) {
        String host = "http://arhiva.deversoft.ro";
        String localhost = "http://localhost";
        String fullUrl = host + ":9987/tracking/upload";
        String reply = "";
        try {
            FileUtils.writeTextToFile("tosend.xml", content);
            File f = new File("tosend.xml");
            this.sendPost3(f, fullUrl);
        }
        catch (IOException e) {
            Logger.logException(this, (Exception)e);
        }
        return reply != null;
    }

    private void sendPost3(File fileOnDisk, String requestURL) {
        String charset = "UTF-8";
        try {
            MultipartUtility multipart = new MultipartUtility(requestURL, charset);
            multipart.addHeaderField("User-Agent", "CodeJava");
            multipart.addHeaderField("Test-Header", "Header-Value");
            multipart.addFormField("description", "Cool Pictures");
            multipart.addFormField("keywords", "Java,upload,Spring");
            multipart.addFilePart("file", fileOnDisk);
            List<String> response = multipart.finish();
            System.out.println("SERVER REPLIED:");
            for (String line : response) {
                System.out.println(line);
            }
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendUnsentData() {
        try {
            boolean allOK;
            Utils.lock("tracking_log", this.firstConnection);
            String content = this.buildXmlContent();
            if (content != null && (allOK = this.sendXmlFileToServer(content))) {
                SqlUtils.executeUpdate("delete from tracking_log", this.firstConnection);
            }
            Utils.release(this.firstConnection);
        }
        catch (SQLException e) {
            Logger.logError((Object)this, e);
        }
        catch (IllegalAccessException e) {
            Logger.logError((Object)this, e);
        }
        finally {
            try {
                this.firstConnection.commit();
            }
            catch (SQLException e) {
                Logger.logError((Object)this, e);
            }
        }
    }
}

