/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.tva;

import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.Logger;
import ro.atreides.utils.config.Config;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.db.TvaDao;
import ro.atreides.utils.tva.Tva;

public class TvaLogic
extends EventGenerator {
    private static TvaLogic instance = null;
    private ConnectionPool pool = ConnectionPool.getInstance();
    private double cotaTva = Config.getInstance().getDouble("tvaProcent");

    private TvaLogic() {
        Logger.logDebug(this, "Cota Tva NOI : " + this.cotaTva);
    }

    private synchronized TvaDao getDao() {
        ConnectionWrapper connection = this.pool.requestConnection();
        TvaDao dao = null;
        while (dao == null) {
            dao = (TvaDao)this.pool.getDao(TvaDao.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(TvaDao.class.getName(), connection);
        }
        return dao;
    }

    public static synchronized TvaLogic getInstance() {
        if (instance == null) {
            instance = new TvaLogic();
        }
        return instance;
    }

    public static double getPretFaraTva(double pretCuTva, double cotaTva) {
        return pretCuTva / (1.0 + cotaTva);
    }

    public static double getTvaFromSumaCuTva(double sumaCuTva, double tvaProcent) {
        return sumaCuTva * (100.0 * tvaProcent) / (tvaProcent * 100.0 + 100.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Tva> getTvas() {
        try {
            Vector<Tva> vector = this.getTvasNoCommit();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<Tva> vector = new Vector<Tva>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Vector<Tva> getTvasNoCommit() throws SQLException {
        return this.getDao().getAll();
    }

    public Tva getTvaByIdNoCommit(int idTva) throws SQLException {
        return this.getDao().getById(idTva);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tva getTvaById(int idTva) {
        try {
            Tva tva = this.getTvaByIdNoCommit(idTva);
            return tva;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Tva tva = null;
            return tva;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tva getTvaByCota(double cota) {
        try {
            Tva tva = this.getDao().getByCota(cota - 1.0E-4, cota + 1.0E-4);
            return tva;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Tva tva = null;
            return tva;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTva(double cota, String casaMarcat) {
        Tva t = new Tva(-1, cota, casaMarcat);
        try {
            this.getDao().add(t);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTva(Tva toUpdate) {
        try {
            this.getDao().update(toUpdate);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTva(Tva tva) {
        try {
            this.getDao().delete(tva);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    @Deprecated
    public double getCotaTva() {
        return this.cotaTva;
    }
}

