/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.units;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.LanguageProvider;
import ro.atreides.utils.Logger;
import ro.atreides.utils.Unit;
import ro.atreides.utils.UnitsProvider;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.units.db.UnitsImpl;

public class UnitsLogic
extends EventGenerator
implements UnitsProvider {
    private static UnitsLogic instance;
    private LanguageProvider languageProvider;
    private ConnectionPool pool;
    private Hashtable<String, Unit> unitsHash = new Hashtable();

    private UnitsLogic() {
        this.pool = ConnectionPool.getInstance();
    }

    public static synchronized UnitsLogic getInstance() {
        if (instance == null) {
            instance = new UnitsLogic();
        }
        return instance;
    }

    private synchronized UnitsImpl getUnitsImpl() {
        ConnectionWrapper connection = this.pool.requestConnection();
        UnitsImpl dao = null;
        while (dao == null) {
            dao = (UnitsImpl)this.pool.getDao(UnitsImpl.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(UnitsImpl.class.getName(), connection);
        }
        return dao;
    }

    public void setLanguageProvider(LanguageProvider languageProvider) {
        this.languageProvider = languageProvider;
    }

    @Override
    public Vector getUnitati() {
        try {
            int language = this.languageProvider.getCurrentUserLanguage();
            return this.getUnitsImpl().getUnitati(language);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            return new Vector();
        }
    }

    public Unit getUnitByIdNoCommit(Integer id) throws SQLException {
        int language = this.languageProvider.getCurrentUserLanguage();
        return this.getUnitsImpl().getUnitById(id, language);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Unit getUnitById(Integer id) {
        try {
            Unit unit = this.getUnitByIdNoCommit(id);
            return unit;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Unit unit = null;
            return unit;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Unit getUnitByName(String name) {
        try {
            Unit unit = this.getUnitByNameNoCommit(name);
            return unit;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Unit unit = null;
            return unit;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Unit getUnitByNameNoCommit(String name) throws SQLException {
        int language = this.languageProvider.getCurrentUserLanguage();
        return this.getUnitsImpl().getUnitByName(name, language);
    }

    public int addUnitNoCommit(String label) throws SQLException {
        int language = this.languageProvider.getCurrentUserLanguage();
        this.getUnitsImpl().addKey(label);
        int idKey = this.pool.getIdentityLocal();
        this.getUnitsImpl().addUnit(label, language, idKey);
        int result = this.pool.getIdentityLocal();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addUnit(String label) {
        int result = -1;
        try {
            result = this.addUnitNoCommit(label);
            this.pool.commit();
            this.notifyListeners(12);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            this.pool.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteUnit(Unit u) {
        try {
            this.getUnitsImpl().deleteUnit(u.getId());
            this.pool.commit();
            this.notifyListeners(12);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    public Unit getUnitateMasuraFromHashNoCommit(String um) throws SQLException {
        Unit unitate = this.unitsHash.get(um);
        if (unitate == null) {
            unitate = UnitsLogic.getInstance().getUnitByNameNoCommit(um);
            if (unitate == null) {
                int unitId = UnitsLogic.getInstance().addUnitNoCommit(um);
                unitate = this.getUnitByIdNoCommit(unitId);
            }
            this.unitsHash.put(um, unitate);
        }
        return unitate;
    }
}

