/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.units.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.utils.Unit;
import ro.atreides.utils.db.DaoInterface;

public class UnitsImpl
implements DaoInterface {
    private PreparedStatement selectAllUnits;
    private PreparedStatement selectUnitById;
    private PreparedStatement selectUnitByName;
    private PreparedStatement addUnit;
    private PreparedStatement addKey;
    private PreparedStatement addMessage;
    private PreparedStatement deleteUnit;
    private Connection connection;

    public UnitsImpl(Connection conn) throws SQLException {
        this.connection = conn;
        this.buildPreparedStatements();
    }

    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public void buildPreparedStatements() throws SQLException {
        this.selectUnitByName = this.connection.prepareStatement("select units.id as id, messages.label as label from units inner join keys on units.id_key = keys.id inner join messages on keys.id = messages.id_key where messages.label = ? and messages.id_lang = ? and units.status = 1");
        this.selectUnitById = this.connection.prepareStatement("select units.id as id, messages.label as label from units inner join keys on units.id_key = keys.id inner join messages on keys.id = messages.id_key where units.id = ? and messages.id_lang = ?");
        this.selectAllUnits = this.connection.prepareStatement("select units.id as id, messages.label as label from units inner join keys on units.id_key = keys.id inner join messages on keys.id = messages.id_key where messages.id_lang = ? and units.status = 1");
        this.addKey = this.connection.prepareStatement("insert into keys ( label ) values ( ? )");
        this.addMessage = this.connection.prepareStatement("insert into messages ( id_key, id_lang, label ) values ( ?, ?, ? )");
        this.addUnit = this.connection.prepareStatement("insert into units ( id_key ) values ( ? )");
        this.deleteUnit = this.connection.prepareStatement("update units set status = 2 where id = ?");
    }

    public Vector getUnitati(int idLanguage) throws SQLException {
        Vector<Unit> result = new Vector<Unit>();
        this.selectAllUnits.setInt(1, idLanguage);
        ResultSet rs = this.selectAllUnits.executeQuery();
        while (rs.next()) {
            Unit u = this.getUnitFromResultSet(rs);
            result.add(u);
        }
        rs.close();
        return result;
    }

    private Unit getUnitFromResultSet(ResultSet rs) throws SQLException {
        Unit u = new Unit();
        u.setId(rs.getInt("id"));
        u.setLabel(rs.getString("label"));
        return u;
    }

    public Unit getUnitById(int id, int idLanguage) throws SQLException {
        this.selectUnitById.setInt(1, id);
        this.selectUnitById.setInt(2, idLanguage);
        ResultSet rs = this.selectUnitById.executeQuery();
        Unit result = null;
        if (rs.next()) {
            result = this.getUnitFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public Unit getUnitByName(String name, int idLanguage) throws SQLException {
        this.selectUnitByName.setString(1, name);
        this.selectUnitByName.setInt(2, idLanguage);
        ResultSet rs = this.selectUnitByName.executeQuery();
        Unit result = null;
        if (rs.next()) {
            result = this.getUnitFromResultSet(rs);
        }
        rs.close();
        return result;
    }

    public void addKey(String label) throws SQLException {
        this.addKey.setString(1, label);
        this.addKey.execute();
    }

    public void addUnit(String label, int idLanguage, int idKey) throws SQLException {
        this.addMessage.setInt(1, idKey);
        this.addMessage.setInt(2, idLanguage);
        this.addMessage.setString(3, label);
        this.addMessage.execute();
        this.addUnit.setInt(1, idKey);
        this.addUnit.execute();
    }

    public void deleteUnit(int id) throws SQLException {
        this.deleteUnit.setInt(1, id);
        this.deleteUnit.execute();
    }
}

