/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.units.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import ro.atreides.utils.Unit;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.units.UnitsLogic;

public class UnitsPanel
extends AbstractListPanel {
    @Override
    public String[] buildColumns() {
        return new String[]{Utils.getTranslation(LangRoAll.unitateMasura, new String[0])};
    }

    @Override
    public Class[] buildTypes() {
        return Utils.getStringClass(this.buildColumns().length);
    }

    @Override
    public Vector buildData() {
        return UnitsLogic.getInstance().getUnitati();
    }

    @Override
    public AbstractTM buildTableModel() {
        AbstractTM tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return false;
            }

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Unit mp = (Unit)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return mp.getLabel();
                    }
                }
                return null;
            }
        });
        return tm;
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 10;
        c.fill = 0;
        c.weightx = 1.0;
        c.gridheight = 1;
        c.gridwidth = 1;
        c.insets = new Insets(2, 0, 2, 0);
        c.gridx = 0;
        c.gridy = 0;
        result.add((Component)new JLabel(Utils.getTranslation(LangRoAll.unitateMasura, new String[0])), c);
        ++c.gridx;
        final JTextField mpText = new JTextField(10);
        result.add((Component)mpText, c);
        final UnitsPanel parent = this;
        ++c.gridx;
        JButton adaugare = new JButton(LangRoAll.adauga);
        adaugare.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String toAdd = mpText.getText();
                if (Validators.correctString(toAdd)) {
                    UnitsLogic.getInstance().addUnit(toAdd);
                    UnitsPanel.this.refreshTable();
                    mpText.setText("");
                    mpText.requestFocus();
                } else {
                    DialogUtils.errorDialog(parent, LangRoAll.unitateMasuraCompletati, LangRoAll.nuPotContinua);
                    mpText.requestFocus();
                }
            }
        });
        result.add((Component)adaugare, c);
        result.setBorder(new TitledBorder(Utils.getTranslation(LangRoAll.unitateMasura, new String[0])));
        return result;
    }

    @Override
    public void doStuff() {
        this.display();
    }
}

