/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.valute;

import java.sql.SQLException;
import java.util.Vector;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.stocks.StockLogic;
import ro.atreides.utils.EventGenerator;
import ro.atreides.utils.Logger;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.db.ConnectionWrapper;
import ro.atreides.utils.valute.Valuta;
import ro.atreides.utils.valute.ValuteImpl;

public class ValuteLogic
extends EventGenerator {
    private static ValuteLogic instance;
    private ConnectionPool pool = ConnectionPool.getInstance();

    public static synchronized ValuteLogic getInstance() {
        if (instance == null) {
            instance = new ValuteLogic();
        }
        return instance;
    }

    private synchronized ValuteImpl getValuteImpl() {
        ConnectionWrapper connection = this.pool.requestConnection();
        ValuteImpl dao = null;
        while (dao == null) {
            dao = (ValuteImpl)this.pool.getDao(ValuteImpl.class, connection);
            if (dao != null) continue;
            this.pool.buildDao(ValuteImpl.class.getName(), connection);
        }
        return dao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<Valuta> getAllValute() {
        try {
            Vector<Valuta> vector = this.getValuteImpl().getAllValute();
            return vector;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Vector<Valuta> vector = new Vector<Valuta>();
            return vector;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addValuta(Valuta valuta) {
        try {
            this.getValuteImpl().addValuta(valuta);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Valuta getValutaById(int idValuta) {
        try {
            Valuta valutaById;
            Valuta valuta = valutaById = this.getValutaByIdNoCommit(idValuta);
            return valuta;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Valuta valuta = null;
            return valuta;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    public Valuta getValutaByIdNoCommit(int idValuta) throws SQLException {
        return this.getValuteImpl().getValutaById(idValuta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Valuta getValutaFromCategorie(int idCategorie) {
        try {
            Integer idValuta = NomeclaturaLogic.getInstance().getIdValutaFromCategorieNoCommit(idCategorie);
            if (idValuta != -1) {
                Valuta valuta = this.getValuteImpl().getValutaById(idValuta);
                return valuta;
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Valuta getValutaFromProduct(int idProduct) {
        Valuta result = null;
        try {
            result = this.getValutaFromProductNoCommit(idProduct);
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Valuta valuta = null;
            return valuta;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
        return result;
    }

    public Valuta getValutaFromProductNoCommit(int idProduct) throws SQLException {
        int idStock = StockLogic.getInstance().getIdStockForProductIdNoCommit(idProduct);
        Integer idValuta = StockLogic.getInstance().getIdValutaForStockNoCommit(idStock);
        if (idValuta == Valuta.mostenitaDinCategorie) {
            Integer idCategorie = NomeclaturaLogic.getInstance().getIdCategoryForIdProductNoCommit(idProduct);
            idValuta = NomeclaturaLogic.getInstance().getIdValutaFromCategorieNoCommit(idCategorie);
        }
        return this.getValutaByIdNoCommit(idValuta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateValuta(Valuta v) {
        try {
            this.getValuteImpl().updateValuta(v);
            NomeclaturaLogic.getInstance().notifyListeners(456);
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteValute(Vector<Valuta> valute) {
        try {
            for (Valuta valuta : valute) {
                this.getValuteImpl().deleteValutaById(valuta.getId());
            }
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                Logger.logException(this, (Exception)e1);
            }
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Valuta getValutaPrincipala() {
        try {
            Valuta valuta = this.getValuteImpl().getValutaPrincipala();
            return valuta;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Valuta valuta = null;
            return valuta;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Valuta getValutaByDenumire(String denumire) {
        try {
            Valuta valuta = this.getValuteImpl().getValutaByDenumire(denumire);
            return valuta;
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            Valuta valuta = null;
            return valuta;
        }
        finally {
            try {
                this.pool.commit();
            }
            catch (SQLException e) {
                Logger.logException(this, (Exception)e);
            }
            this.pool.releaseConnection();
        }
    }
}

