/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.utils.valute;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.GuiUtils;
import ro.atreides.utils.gui.Validators;
import ro.atreides.utils.gui.dialogs.DialogUtils;
import ro.atreides.utils.gui.table.AbstractListPanel;
import ro.atreides.utils.gui.table.AbstractTM;
import ro.atreides.utils.gui.table.TmInterface;
import ro.atreides.utils.multilang.LangRoAll;
import ro.atreides.utils.valute.Valuta;
import ro.atreides.utils.valute.ValuteLogic;

public class ValutePanel
extends AbstractListPanel {
    private boolean principalaExists = false;

    @Override
    public AbstractTM buildTableModel() {
        this.tm = new AbstractTM(this.buildColumns(), this.buildTypes(), new TmInterface(){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex, Vector data) {
                Valuta v = (Valuta)data.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return v.getDenumire();
                    }
                    case 1: {
                        return v.isPrincipala();
                    }
                    case 2: {
                        return v.getParitate();
                    }
                }
                return null;
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex == 0 || columnIndex == 2;
            }

            @Override
            public void setValueAt(Object aValue, int rowIndex, int columnIndex, Vector data) {
                Valuta v = (Valuta)data.elementAt(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        String denumire = (String)aValue;
                        v.setDenumire(denumire);
                        ValuteLogic.getInstance().updateValuta(v);
                        break;
                    }
                    case 2: {
                        String paritate = (String)aValue;
                        if (!Validators.correctDouble(paritate)) break;
                        Double paritateF = Double.valueOf(paritate);
                        v.setParitate(paritateF);
                        ValuteLogic.getInstance().updateValuta(v);
                        break;
                    }
                }
            }
        });
        return this.tm;
    }

    @Override
    public JPanel getBottomPanel() {
        JPanel result = new JPanel((LayoutManager)new MigLayout("fill", "[][grow][][][][grow]"));
        result.add(new JLabel("Denumire"));
        final JTextField denumireField = new JTextField();
        result.add((Component)denumireField, "growx");
        result.add(new JLabel("Principala"));
        final JCheckBox principalaSelected = new JCheckBox();
        result.add(principalaSelected);
        result.add(new JLabel("Paritate"));
        final JTextField paritateField = new JTextField();
        result.add((Component)paritateField, "growx, wrap");
        JButton adauga = new JButton("Adauga");
        adauga.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String denumireString = denumireField.getText();
                if (!Validators.correctString(denumireString)) {
                    DialogUtils.okDialog(GuiUtils.currentFrame, "Completati denumirea", LangRoAll.nuPotContinua);
                    return;
                }
                boolean isPrincipala = principalaSelected.isSelected();
                String paritateString = paritateField.getText().toString();
                if (!Validators.correctDouble(paritateString)) {
                    DialogUtils.okDialog(GuiUtils.currentFrame, "Valoare incorecta !", LangRoAll.nuPotContinua);
                    Utils.setSelectionForTextField(paritateField);
                    return;
                }
                Double paritate = Double.valueOf(paritateString);
                ValuteLogic.getInstance().addValuta(new Valuta(denumireString, isPrincipala, paritate));
                ValutePanel.this.refreshTable();
                NomeclaturaLogic.getInstance().notifyListeners(456);
                denumireField.setText("");
                principalaSelected.setSelected(false);
                paritateField.setText("");
            }
        });
        result.add(adauga);
        JButton sterge = new JButton("Sterge");
        sterge.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (DialogUtils.confirmDialog(GuiUtils.currentFrame, "Stergeti valutele selectate?", LangRoAll.atentie)) {
                    int[] selectedRows = ValutePanel.this.table.getSelectedRows();
                    Vector data = ValutePanel.this.tm.getData();
                    Vector<Valuta> toDelete = new Vector<Valuta>();
                    for (int selectedRow : selectedRows) {
                        toDelete.add((Valuta)data.get(selectedRow));
                    }
                    ValuteLogic.getInstance().deleteValute(toDelete);
                    ValutePanel.this.refreshTable();
                    NomeclaturaLogic.getInstance().notifyListeners(456);
                }
            }
        });
        result.add(sterge);
        return result;
    }

    @Override
    public Vector buildData() {
        return ValuteLogic.getInstance().getAllValute();
    }

    @Override
    public String[] buildColumns() {
        return new String[]{"Denumire", "Principala", "Val raportata la valuta principala"};
    }

    @Override
    public Class[] buildTypes() {
        return new Class[]{String.class, Boolean.class, String.class};
    }

    @Override
    public void doStuff() {
        this.display();
    }

    private boolean existsValutaPrincipala(Vector<Valuta> data) {
        for (Valuta valuta : data) {
            if (!valuta.isPrincipala()) continue;
            return true;
        }
        return false;
    }
}

