/*
 * Decompiled with CFR 0.152.
 */
package ro.atreides.xmllauncher;

import java.io.IOException;
import java.util.Properties;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.atreides.utils.Utils;
import ro.atreides.utils.gui.Validators;

public class XmlProperties {
    public static final String MODULE_KEY = "module";
    public static final String ECR_KEY = "ecr";
    public static final String APPLICATION_KEY = "application";
    public static final String SECTION_KEY = "section";

    public static Properties readPropertiesFromXml(String xmlFile, final boolean allowEmptyParams) throws IOException, SAXException {
        final Properties p = new Properties();
        Utils.importXml(new DefaultHandler(){

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                String class1;
                if (qName.equalsIgnoreCase("param")) {
                    String attr = attributes.getValue("name");
                    String val = attributes.getValue("value");
                    if (allowEmptyParams || Validators.correctString(val)) {
                        p.put(attr, val);
                    }
                }
                if (qName.equalsIgnoreCase(XmlProperties.MODULE_KEY)) {
                    String moduleName = attributes.getValue("name");
                    p.put(XmlProperties.MODULE_KEY, moduleName);
                }
                if (qName.equalsIgnoreCase(XmlProperties.SECTION_KEY)) {
                    String section = attributes.getValue("value");
                    p.put(XmlProperties.SECTION_KEY, section);
                }
                if (qName.equalsIgnoreCase(XmlProperties.APPLICATION_KEY)) {
                    class1 = attributes.getValue("class");
                    p.put(XmlProperties.APPLICATION_KEY, class1);
                }
                if (qName.equalsIgnoreCase(XmlProperties.ECR_KEY)) {
                    class1 = attributes.getValue("name");
                    p.put(XmlProperties.ECR_KEY, class1);
                }
            }
        }, xmlFile);
        return p;
    }
}

