/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.android.gsoncasaserver;

import com.google.code.gsonrmi.annotations.RMI;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.sql.SQLException;
import java.util.Date;
import java.util.Vector;
import ro.atreides.nomenclatura.NomeclaturaLogic;
import ro.atreides.nomenclatura.Product;
import ro.atreides.restaurant.base.Sale;
import ro.atreides.restaurant.logic.BonFIscalInterface;
import ro.atreides.restaurant.logic.RestLogic;
import ro.atreides.users.User;
import ro.atreides.utils.Client;
import ro.atreides.utils.Logger;
import ro.atreides.utils.db.ConnectionPool;
import ro.atreides.utils.plati.Plata;
import ro.atreides.utils.plati.TipPlata;
import ro.atreides.utils.plati.TipPlataProvider;
import ro.deversoft.android.foodtablet.DeverFood.utils.gson.beans.Payment;
import ro.deversoft.android.foodtablet.DeverFood.utils.gson.beans.SaleUpper;
import ro.deversoft.android.foodtablet.gsonserver.GSONEntity;

public class RealImplCasaGSONServer
extends GSONEntity {
    private static RealImplCasaGSONServer deverFoodGsonCasa;
    private ConnectionPool pool = ConnectionPool.getInstance();

    private RealImplCasaGSONServer(String url, String serverName, String clientName, Integer listeningPort) throws InvocationTargetException, URISyntaxException {
        super(url, serverName, clientName, listeningPort);
    }

    public static RealImplCasaGSONServer getFirstInstance(String url, String serverName, String clientName, Integer listeningPort) {
        try {
            deverFoodGsonCasa = new RealImplCasaGSONServer(url, serverName, clientName, listeningPort);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return deverFoodGsonCasa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RMI
    public String printBonFiscal(Vector<SaleUpper> saleVector, Vector<Payment> paymentVector, Vector<String> comentarii, String chararcter, String orderIdentifier, String codOperator, Double reducere, String key) {
        try {
            int clientIndex = 0;
            Vector<Sale> newSales = new Vector<Sale>();
            for (SaleUpper saleUpper : saleVector) {
                Product product = NomeclaturaLogic.getInstance().getProductByIdNoCommit(saleUpper.getIdProduct());
                Sale newSale = RestLogic.getInstance().buildSaleNoCommit(product, saleUpper.getQuantity(), 0.0, "", -1, -1, -1, -1, -1, System.currentTimeMillis(), saleUpper.getPrice(), "", clientIndex);
                newSales.add(newSale);
            }
            Vector<Plata> plati = new Vector<Plata>();
            if (paymentVector != null) {
                for (Payment payment : paymentVector) {
                    String tipPlataName = payment.getPayMode();
                    TipPlata tp = TipPlataProvider.getInstance().getTipPlataByCodCasa(tipPlataName);
                    if (tp == null) {
                        tp = TipPlataProvider.getInstance().getTipPlataByNameNoCommit(tipPlataName);
                    }
                    if (tp != null) {
                        Plata plata = new Plata(tp.getId(), payment.getSumAmount(), payment.getPayMode(), payment.getProductLine1(), payment.getProductLine2(), clientIndex);
                        plata.setTipPlata(tp.getLabel());
                        plati.add(plata);
                        continue;
                    }
                    Logger.logWarning(this, "Am primit un payment " + tipPlataName + " suma " + payment.getSumAmount() + " dar nu l-am gasit in server !!");
                }
            }
            User user = null;
            Client client = null;
            int idClient = -1;
            String locatieName = "";
            String tableName = "";
            int idOrder = -1;
            BonFIscalInterface bonfiscalinterface = new BonFIscalInterface(){

                @Override
                public double[] getIstoricIncasariClient(Client c, Date start, Date end) {
                    return new double[0];
                }

                @Override
                public void addPlata(int idOrder, TipPlata tp, double diff, String detalii, int clientIndex) throws SQLException {
                }
            };
            RestLogic.getInstance().printBonFiscalNoArch(newSales, plati, user, client, orderIdentifier, comentarii, idOrder, "", "", bonfiscalinterface, idClient, locatieName, tableName, clientIndex);
            this.pool.commit();
        }
        catch (SQLException e) {
            Logger.logException(this, (Exception)e);
            try {
                this.pool.rollBack();
            }
            catch (SQLException e1) {
                // empty catch block
            }
        }
        finally {
            this.pool.releaseConnection();
        }
        return "";
    }
}

