/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.drivers.datecs.gen3.noarch.commands;

import java.util.Vector;
import ro.deversoft.drivers.datecs.gen3.noarch.Utils;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.Command;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.dailyClosure.Raport;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.informationToHost.DiagnosticResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.informationToHost.InfoCurentReceipt;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.informationToHost.LastDocumentPrinted;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.informationToHost.ReadingDateResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.informationToHost.TaxRegistrationNumber;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.others.CloseNonFiscalReceiptResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.others.DebetingCrediting;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.others.OpenNonFiscalReceiptResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.reports.ItemReportResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.reports.TaxRatesDruingPeriodResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.sales.ClosingFiscalReceiptResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.sales.OpeningFiscalReceiptResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.sales.SubtotalResponse;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.response.sales.TotalResponse;

public class Response
extends Command {
    private byte[] data;
    private byte[] status;
    private boolean nakResponse = false;
    private boolean corectResponse = false;
    private boolean timeout = false;
    private static int tipRaspuns;
    private Vector<String> errors = new Vector();
    private Vector<String> warnings = new Vector();
    private Vector<String> infos = new Vector();

    public Response(byte[] data, byte[] status) {
        this.data = data;
        this.status = status;
        this.corectResponse = true;
        this.readStatus(status);
    }

    public Response() {
    }

    @Override
    protected byte[] buildData() {
        byte[] responseData = new byte[this.data.length + this.status.length + 1];
        System.arraycopy(this.data, 0, responseData, 0, this.data.length);
        responseData[this.data.length] = 4;
        System.arraycopy(this.status, 0, responseData, responseData.length - 6, this.status.length);
        return responseData;
    }

    public static Object buildResponse(byte[] data) {
        byte cmd = data[0];
        byte[] responseArray = new byte[data.length - 1];
        System.arraycopy(data, 1, responseArray, 0, data.length - 1);
        String responseString = Utils.getStringFromAscii(responseArray);
        String[] responseStringArray = new String[data.length - 1];
        if (data.length > 1) {
            responseStringArray = responseString.split(",");
        }
        switch (cmd) {
            case 69: {
                Raport raport = new Raport(responseStringArray);
                tipRaspuns = 1;
                return raport;
            }
            case 103: {
                InfoCurentReceipt infoCurentReceipt = new InfoCurentReceipt(responseStringArray);
                tipRaspuns = 2;
                return infoCurentReceipt;
            }
            case 113: {
                LastDocumentPrinted lastDocumentPrinted = new LastDocumentPrinted(responseStringArray);
                tipRaspuns = 3;
                return lastDocumentPrinted;
            }
            case 99: {
                TaxRegistrationNumber taxRegistrationNumber = new TaxRegistrationNumber(responseStringArray);
                tipRaspuns = 4;
                return taxRegistrationNumber;
            }
            case 39: {
                CloseNonFiscalReceiptResponse closeNonFiscalReceiptResponse = new CloseNonFiscalReceiptResponse(responseStringArray);
                tipRaspuns = 5;
                return closeNonFiscalReceiptResponse;
            }
            case 70: {
                DebetingCrediting debetingCrediting = new DebetingCrediting(responseStringArray);
                tipRaspuns = 6;
                return debetingCrediting;
            }
            case 38: {
                OpenNonFiscalReceiptResponse openNonFiscalReceiptResponse = new OpenNonFiscalReceiptResponse(responseStringArray);
                tipRaspuns = 7;
                return openNonFiscalReceiptResponse;
            }
            case 111: {
                ItemReportResponse itemReportResponse = new ItemReportResponse(responseStringArray);
                tipRaspuns = 8;
                return itemReportResponse;
            }
            case 50: {
                TaxRatesDruingPeriodResponse taxRatesDruingPeriodResponse = new TaxRatesDruingPeriodResponse(responseStringArray);
                tipRaspuns = 9;
                return taxRatesDruingPeriodResponse;
            }
            case 56: {
                ClosingFiscalReceiptResponse closingFiscalReceiptResponse = new ClosingFiscalReceiptResponse(responseStringArray);
                tipRaspuns = 10;
                return closingFiscalReceiptResponse;
            }
            case 48: {
                OpeningFiscalReceiptResponse openingFiscalReceiptResponse = new OpeningFiscalReceiptResponse(responseStringArray);
                tipRaspuns = 11;
                return openingFiscalReceiptResponse;
            }
            case 51: {
                SubtotalResponse subtotalResponse = new SubtotalResponse(responseStringArray);
                tipRaspuns = 12;
                return subtotalResponse;
            }
            case 53: {
                TotalResponse totalResponse = new TotalResponse(responseArray);
                tipRaspuns = 13;
                return totalResponse;
            }
            case 62: {
                ReadingDateResponse readingDateResponse = new ReadingDateResponse(responseStringArray);
                tipRaspuns = 14;
                return readingDateResponse;
            }
            case 90: {
                DiagnosticResponse diagnosticResponse = new DiagnosticResponse(responseStringArray);
                tipRaspuns = 15;
                return diagnosticResponse;
            }
        }
        return null;
    }

    private void readStatus(byte[] status) {
        byte byte0 = status[0];
        boolean syntaxError = Utils.isOn(byte0, 0);
        boolean cmdCodeInvalid = Utils.isOn(byte0, 1);
        boolean notConnectedToCustomerDisplay = Utils.isOn(byte0, 3);
        boolean generalError = Utils.isOn(byte0, 5);
        if (syntaxError) {
            this.errors.add("Incoming data has syntax error.");
        }
        if (cmdCodeInvalid) {
            this.errors.add("Code of incoming command is invalid.");
        }
        if (notConnectedToCustomerDisplay) {
            this.warnings.add("A customer display is not connected.");
        }
        if (generalError) {
            this.errors.add("General error -OR al errors marked whit \"#\".");
        }
        byte byte1 = status[1];
        boolean internalTaxTerminalNotRespond = Utils.isOn(byte1, 6);
        boolean commandCantPerformedInCurrentFiscalMode = Utils.isOn(byte1, 1);
        boolean sumsOverflows = Utils.isOn(byte1, 0);
        if (internalTaxTerminalNotRespond) {
            this.errors.add("Internal tax terminal does not respond.");
        }
        if (commandCantPerformedInCurrentFiscalMode) {
            this.errors.add("Command cannot be performed in current fiscal mode");
        }
        if (sumsOverflows) {
            this.errors.add("During command some of the fields for the sums overflow.");
        }
        byte byte2 = status[2];
        boolean noPaper = Utils.isOn(byte2, 0);
        boolean endOfKLEN = Utils.isOn(byte2, 2);
        boolean fiscalReceiptOpened = Utils.isOn(byte2, 3);
        boolean commingEndOfKLEN = Utils.isOn(byte2, 4);
        boolean nonFiscalReceiptOpened = Utils.isOn(byte2, 5);
        if (nonFiscalReceiptOpened) {
            this.infos.add("(INFO) A non-fiscal receipt is open.");
        }
        if (commingEndOfKLEN) {
            this.warnings.add("(INFO) Coming end of KLEN (10Mb free).");
        }
        if (fiscalReceiptOpened) {
            this.infos.add("(INFO) A fiscal receipt is open.");
        }
        if (endOfKLEN) {
            this.warnings.add("End of KLEN (les than 1Mb free).");
        }
        if (noPaper) {
            this.errors.add("No paper.");
        }
        byte byte3 = status[3];
        boolean d = Utils.isOn(byte3, 4);
        byte[] binary = Utils.getBinary(byte3);
        byte byte4 = status[4];
        boolean mistakesMarked = Utils.isOn(byte4, 5);
        boolean fiscalMemoryFull = Utils.isOn(byte4, 4);
        boolean spaceNotMoreThan50 = Utils.isOn(byte4, 3);
        boolean serialNrFiscalNrAreSet = Utils.isOn(byte4, 2);
        boolean ENKSet = Utils.isOn(byte4, 1);
        if (mistakesMarked) {
            this.warnings.add("OR of all mistakes marked by \"*\" from bytes 4 and 5.");
        }
        if (fiscalMemoryFull) {
            this.errors.add("Fiscal memory is full.");
        }
        if (spaceNotMoreThan50) {
            this.warnings.add("There is space for not more than 50 entries in fiscal memory.");
        }
        if (serialNrFiscalNrAreSet) {
            this.infos.add("The serial number on fiscal memory is set.");
        }
        if (ENKSet) {
            this.infos.add("(INFO) ENK (EIK - Unified Identification Code) is set.");
        }
        byte byte5 = status[5];
        boolean taxRatesHasBeenEntered = Utils.isOn(byte5, 4);
        boolean fiscalRegisterIsInFiscalMode = Utils.isOn(byte5, 3);
        boolean fiscalMemoryIsFormated = Utils.isOn(byte5, 1);
        if (taxRatesHasBeenEntered) {
            this.infos.add("Tax rates have been entered at least once.");
        }
        if (fiscalRegisterIsInFiscalMode) {
            this.infos.add("The cas register is in fiscal mode.");
        }
        if (fiscalMemoryIsFormated) {
            this.infos.add("(INFO) The fiscal memory is formatted.");
        }
    }

    public boolean isNakResponse() {
        return this.nakResponse;
    }

    public boolean isCorectResponse() {
        return this.corectResponse;
    }

    public void setCorectResponse(boolean corectResponse) {
        this.corectResponse = corectResponse;
    }

    public int getTipRaspuns() {
        return tipRaspuns;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setNakResponse(boolean nakResponse) {
        this.nakResponse = nakResponse;
    }

    public Vector<String> getErrors() {
        return this.errors;
    }

    public Vector<String> getInfos() {
        return this.infos;
    }

    public Vector<String> getWarnings() {
        return this.warnings;
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    public void setTimeout(boolean timeout) {
        this.timeout = timeout;
    }
}

