/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.drivers.datecs.gen3.noarch.commands.request.sales;

import ro.deversoft.drivers.datecs.gen3.noarch.Utils;
import ro.deversoft.drivers.datecs.gen3.noarch.commands.Command;

public class OpenFiscalReceipt
extends Command {
    private static byte CMD = (byte)48;
    private int operatorCode;
    private String operatorPassword;
    private Integer nrPointOfSale;
    private boolean printInvoice;

    public OpenFiscalReceipt(int operatorCode, String operatorPassword, Integer nrPointOfSale, boolean printInvoice) {
        this.operatorCode = operatorCode;
        this.operatorPassword = operatorPassword;
        this.nrPointOfSale = nrPointOfSale;
        this.printInvoice = printInvoice;
        this.getBytes(0);
    }

    @Override
    protected byte[] buildData() {
        String operatorCodeString = String.valueOf(this.operatorCode);
        int lenghtOfData = operatorCodeString.length() + this.operatorPassword.length() + 2;
        byte[] nrPointOfSaleArray = new byte[]{};
        if (this.nrPointOfSale != null) {
            nrPointOfSaleArray = Utils.getAsciiCod(String.valueOf(this.nrPointOfSale));
            lenghtOfData = lenghtOfData + 1 + nrPointOfSaleArray.length;
        }
        if (this.printInvoice) {
            lenghtOfData += 2;
        }
        byte[] data = new byte[lenghtOfData];
        data[0] = CMD;
        byte[] opertorNameAscii = Utils.getAsciiCod(operatorCodeString);
        System.arraycopy(opertorNameAscii, 0, data, 1, opertorNameAscii.length);
        data[opertorNameAscii.length + 1] = 44;
        byte[] opratorPasswordAscii = Utils.getAsciiCod(this.operatorPassword);
        System.arraycopy(opratorPasswordAscii, 0, data, operatorCodeString.length() + 2, opratorPasswordAscii.length);
        if (this.nrPointOfSale != null) {
            data[opertorNameAscii.length + opratorPasswordAscii.length + 2] = 44;
            System.arraycopy(nrPointOfSaleArray, 0, data, opertorNameAscii.length + opratorPasswordAscii.length + 3, nrPointOfSaleArray.length);
            if (this.printInvoice) {
                data[lenghtOfData - 2] = 44;
                data[lenghtOfData - 1] = 73;
            }
        }
        return data;
    }
}

