/*
 * Decompiled with CFR 0.152.
 */
package ro.deversoft.drivers.datecs.gen3.noarch.commands.response.sales;

import ro.deversoft.drivers.datecs.gen3.noarch.Utils;

public class TotalResponse {
    private char paidCode;
    private String infoPaid;
    private double paidAmount;

    public TotalResponse(byte[] data) {
        this.getDataFields(data);
    }

    private void getDataFields(byte[] data) {
        if (data.length > 0) {
            this.paidCode = (char)data[0];
            this.afis(this.paidCode);
            byte[] amount = new byte[data.length - 1];
            System.arraycopy(data, 1, amount, 0, data.length - 1);
            String stringFromAscii = Utils.getStringFromAscii(amount);
            this.paidAmount = !stringFromAscii.isEmpty() ? Double.parseDouble(stringFromAscii) : 0.0;
        }
    }

    public char getPaidCode() {
        return this.paidCode;
    }

    public String getInfoPaid() {
        return this.infoPaid;
    }

    public double getPaidAmount() {
        return this.paidAmount / 100.0;
    }

    public void afis(char response) {
        switch (response) {
            case 'F': {
                this.infoPaid = "Error";
                break;
            }
            case 'E': {
                this.infoPaid = "Calculated sub-total sum is negative.";
                break;
            }
            case 'D': {
                this.infoPaid = "The paid sum is less than the sum of the receipt.";
                break;
            }
            case 'R': {
                this.infoPaid = "The paid sum is greater than the sum of the receipt.";
                break;
            }
            case 'I': {
                this.infoPaid = "An error has occurred because the sum under one of the tax groups is negative.";
            }
        }
    }
}

