/*
 * Decompiled with CFR 0.152.
 */
package com.easynth.lookandfeel;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.plaf.synth.SynthLookAndFeel;

public class EaSynthLookAndFeel
extends SynthLookAndFeel {
    private static final long serialVersionUID = 6942508771080867071L;
    private String synthXml;

    public EaSynthLookAndFeel() {
        try {
            this.load(this.getClass().getResourceAsStream("easynth.xml"), this.getClass());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getDescription() {
        return "EaSynth Look and Feel Designer's default LAF, created by the tool.";
    }

    public String getID() {
        return this.getClass().getSimpleName();
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public boolean isNativeLookAndFeel() {
        return false;
    }

    public boolean isSupportedLookAndFeel() {
        return true;
    }

    public void setDefaultFont(String string, int n, boolean bl, boolean bl2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("$1");
        stringBuilder.append(string);
        stringBuilder.append("$3");
        stringBuilder.append(n);
        stringBuilder.append("$5");
        if (bl || bl2) {
            stringBuilder.append(" style=\"");
            if (bl) {
                stringBuilder.append("BOLD");
                if (bl2) {
                    stringBuilder.append(' ');
                }
            }
            if (bl2) {
                stringBuilder.append("ITALIC");
            }
            stringBuilder.append("\"");
        }
        stringBuilder.append("$7");
        this.replaceXmlSegment("(<style id=\"Default\">\\s*<font name=\")([^\"]*)(\" size=\")([^\"]*)(\")([^/]*)(/>)", stringBuilder.toString());
    }

    public void replaceXmlSegment(String string, String string2) {
        this.replaceXmlSegmentInCache(string, string2);
        this.applyCachedSynthXml();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceXmlSegmentInCache(String string, String string2) {
        Serializable serializable = this;
        synchronized (serializable) {
            if (this.synthXml == null) {
                this.synthXml = this.getSynthXmlAsString();
            }
        }
        serializable = Pattern.compile(string);
        Matcher matcher = ((Pattern)serializable).matcher(this.synthXml);
        this.synthXml = matcher.replaceFirst(string2);
    }

    public void applyCachedSynthXml() {
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.synthXml.getBytes("UTF-8"));
            this.load(byteArrayInputStream, this.getClass());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public String getSynthXmlAsString() {
        InputStream inputStream = this.getClass().getResourceAsStream("easynth.xml");
        if (inputStream != null) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                String string = null;
                StringBuilder stringBuilder = new StringBuilder();
                do {
                    if ((string = bufferedReader.readLine()) == null) continue;
                    stringBuilder.append(string.trim());
                    stringBuilder.append(System.getProperty("line.separator"));
                } while (string != null);
                String string2 = stringBuilder.toString();
                return string2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }
}

