/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.transport;

import com.google.code.gsonrmi.Parameter;
import com.google.code.gsonrmi.transport.Collections;
import com.google.code.gsonrmi.transport.DeliveryFailure;
import com.google.code.gsonrmi.transport.Message;
import com.google.code.gsonrmi.transport.MessageProcessor;
import com.google.code.gsonrmi.transport.Route;
import com.google.code.gsonrmi.transport.Transport;
import com.google.gson.Gson;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;

public abstract class Proxy
extends MessageProcessor {
    protected final Transport transport;
    protected final Gson gson;
    private final Map<String, Connection> cons;
    private final TimerTask cleanupTask;

    protected Proxy(Transport t, Gson serializer) {
        this(t, serializer, new Options());
    }

    protected Proxy(Transport t, Gson serializer, Options options) {
        this.transport = t;
        this.transport.register(this.getScheme(), this.mq);
        this.gson = serializer;
        this.cons = new HashMap<String, Connection>();
        this.cleanupTask = t.sendEvery(new Message(null, Arrays.asList(new Route(URI.create(this.getScheme() + ":proxy"))), new CleanUp()), options.cleanupInterval, options.cleanupInterval);
    }

    protected abstract String getScheme();

    protected abstract Connection createConnection(String var1);

    public void addConnection(Connection c) {
        this.mq.add(new Message(null, null, new AddConnection(c)));
    }

    @Override
    protected void process(Message m) {
        if (m.contentOfType(Transport.Shutdown.class)) {
            this.handle(m.getContentAs(Transport.Shutdown.class, this.gson));
        } else if (m.contentOfType(AddConnection.class)) {
            this.handle(m.getContentAs(AddConnection.class, this.gson));
        } else if (m.contentOfType(CleanUp.class)) {
            this.handle(m.getContentAs(CleanUp.class, this.gson));
        } else {
            this.handle(m);
        }
    }

    protected void handle(Transport.Shutdown m) {
        for (Connection c : this.cons.values()) {
            c.shutdown();
        }
        this.cleanupTask.cancel();
    }

    private void handle(AddConnection m) {
        System.out.println("Adding new Connection: " + m.con.getRemoteAuthority());
        this.cons.put(m.con.getRemoteAuthority(), m.con);
    }

    protected void handle(Message m) {
        LinkedList<Route> failedRoutes = new LinkedList<Route>();
        for (Map.Entry entry : Collections.group(m.dests, (Object)Route.GroupBy.AUTHORITY).entrySet()) {
            String authority = (String)entry.getKey();
            List<Route> dests = entry.getValue();
            Connection c = this.cons.get(authority);
            if (c == null || !c.isAlive()) {
                System.out.println("Removing Connection: " + c);
                this.cons.remove(authority);
                c = this.createConnection(authority);
                if (c != null) {
                    System.out.println("Adding new Connection: " + c.getRemoteAuthority());
                    this.cons.put(authority, c);
                }
            }
            if (c != null) {
                c.send(new Message(m.src, dests, m.content, m.contentType));
                continue;
            }
            failedRoutes.addAll(dests);
        }
        if (!failedRoutes.isEmpty() && !m.contentOfType(DeliveryFailure.class)) {
            DeliveryFailure failure = new DeliveryFailure(new Message(m.src, failedRoutes, m.content, m.contentType));
            this.transport.send(new Message(null, Arrays.asList(m.src), failure));
        }
    }

    protected void handle(CleanUp m) {
        int count = this.cons.size();
        Iterator<Connection> i = this.cons.values().iterator();
        while (i.hasNext()) {
            if (i.next().isAlive()) continue;
            i.remove();
        }
        if (this.cons.size() < count) {
            System.err.println("INFO: " + this.getClass().getSimpleName() + " cleanup connections " + count + " -> " + this.cons.size());
        }
    }

    public Map<String, Connection> getCons() {
        return this.cons;
    }

    public static class OnConnectionClosed {
        public Parameter data;
    }

    public static class CheckConnection {
        public Parameter data;
    }

    public static interface Connection {
        public String getRemoteAuthority();

        public boolean isAlive();

        public void send(Message var1);

        public void shutdown();
    }

    public static class AddConnection {
        public final Connection con;

        public AddConnection(Connection c) {
            this.con = c;
        }
    }

    public static class Options {
        public long cleanupInterval = 60000L;
    }

    protected static class CleanUp {
        protected CleanUp() {
        }
    }
}

