/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.transport;

import com.google.code.gsonrmi.transport.Collections;
import com.google.code.gsonrmi.transport.Message;
import com.google.code.gsonrmi.transport.Route;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.Timer;
import java.util.TimerTask;

public class Transport {
    private final Map<String, Queue<Message>> queues = new HashMap<String, Queue<Message>>();
    private final Timer timer = new Timer();

    public void shutdown() {
        Message m = new Message(null, null, new Shutdown());
        for (Queue<Message> queue : this.queues.values()) {
            queue.add(m);
        }
        this.timer.cancel();
    }

    public void register(String scheme, Queue<Message> messageQueue) {
        this.queues.put(scheme, messageQueue);
    }

    public void send(Message m) {
        for (Map.Entry entry : Collections.group(m.dests, (Object)Route.GroupBy.SCHEME).entrySet()) {
            Queue<Message> queue = this.queues.get(entry.getKey());
            if (queue != null) {
                queue.add(new Message(m.src, entry.getValue(), m.content, m.contentType));
                continue;
            }
            new RuntimeException("No handler for protocol " + (String)entry.getKey()).printStackTrace();
        }
    }

    public TimerTask sendAfter(Message m, long delay) {
        SendTask task = new SendTask(m);
        this.timer.schedule((TimerTask)task, delay);
        return task;
    }

    public TimerTask sendEvery(Message m, long delay, long period) {
        SendTask task = new SendTask(m);
        this.timer.schedule((TimerTask)task, delay, period);
        return task;
    }

    public static class Shutdown {
    }

    private class SendTask
    extends TimerTask {
        private final Message message;

        private SendTask(Message m) {
            this.message = m;
        }

        @Override
        public void run() {
            Transport.this.send(this.message);
        }
    }
}

