/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.transport.rmi;

import com.google.code.gsonrmi.Parameter;
import com.google.code.gsonrmi.RpcError;
import com.google.code.gsonrmi.RpcRequest;
import com.google.code.gsonrmi.RpcResponse;
import com.google.code.gsonrmi.transport.Message;
import com.google.code.gsonrmi.transport.Route;
import com.google.code.gsonrmi.transport.Transport;
import java.util.Arrays;

public class AsyncResponse {
    protected RpcRequest request;
    protected Route dest;
    protected Route src;
    protected RpcResponse response;
    protected Transport transport;

    protected void setRequest(RpcRequest request, Route dest, Route src) {
        this.request = request;
        this.dest = dest;
        this.src = src;
        this.trySend();
    }

    public void send(Object result, Transport transport) {
        this.response = new RpcResponse();
        this.response.result = result != null ? new Parameter(result) : null;
        this.transport = transport;
        this.trySend();
    }

    public void sendException(Exception exception, Transport transport) {
        this.response = new RpcResponse();
        this.response.error = new RpcError(RpcError.INVOCATION_EXCEPTION, exception);
        this.transport = transport;
        this.trySend();
    }

    protected void trySend() {
        if (this.request != null && this.response != null) {
            this.response.id = this.request.id;
            if (this.response.id != null) {
                this.transport.send(new Message(this.dest, Arrays.asList(this.src), this.response));
            } else if (this.response.error != null) {
                System.err.println("Notification failed:  " + this.dest.hops[0] + " method " + this.request.method);
                this.response.error.data.getValue(Exception.class, null).printStackTrace();
            }
            this.request = null;
            this.response = null;
        }
    }
}

