/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.transport.rmi;

import com.google.code.gsonrmi.DefaultParamProcessor;
import com.google.code.gsonrmi.Invoker;
import com.google.code.gsonrmi.ParamValidationException;
import com.google.code.gsonrmi.Parameter;
import com.google.code.gsonrmi.RpcError;
import com.google.code.gsonrmi.RpcRequest;
import com.google.code.gsonrmi.RpcResponse;
import com.google.code.gsonrmi.annotations.Dest;
import com.google.code.gsonrmi.annotations.ParamType;
import com.google.code.gsonrmi.annotations.Session;
import com.google.code.gsonrmi.annotations.Src;
import com.google.code.gsonrmi.transport.Route;
import com.google.code.gsonrmi.transport.rmi.AbstractSession;
import com.google.code.gsonrmi.transport.rmi.AsyncResponse;
import com.google.code.gsonrmi.transport.rmi.Callback;
import com.google.code.gsonrmi.transport.rmi.InvalidSessionException;
import com.google.code.gsonrmi.transport.rmi.RpcHandler;
import com.google.gson.Gson;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DefaultRpcHandler
implements RpcHandler {
    private final Object target;
    private final Invoker invoker;
    private final Map<String, AbstractSession> sessions;

    public DefaultRpcHandler(Object target, Gson paramDeserializer) {
        this.target = target;
        this.invoker = new Invoker(new CustomParamProcessor(paramDeserializer));
        this.sessions = new HashMap<String, AbstractSession>();
    }

    @Override
    public RpcResponse handle(RpcRequest request, Route dest, Route src) {
        RpcResponse response = this.invoker.doInvoke(request, this.target, new Context(dest, src));
        if (response.result != null && response.result.getValue(Object.class, null) instanceof AsyncResponse) {
            response.result.getValue(AsyncResponse.class, null).setRequest(request, dest, src);
            return null;
        }
        return response;
    }

    @Override
    public void handle(RpcResponse response, Route dest, List<Route> srcs, Callback callback) {
        if (callback.session != null) {
            if (callback.session.id != null) {
                this.sessions.put(callback.session.id, callback.session);
                callback.session.lastAccessed = System.currentTimeMillis();
            } else {
                new RuntimeException("Session id is null").printStackTrace();
            }
        }
        RpcRequest request = new RpcRequest();
        request.method = callback.method;
        request.params = Arrays.copyOf(callback.params, callback.params.length + 2);
        request.params[request.params.length - 2] = response.result;
        request.params[request.params.length - 1] = response.error != null ? new Parameter(response.error) : null;
        for (Route src : srcs) {
            RpcResponse r = this.invoker.doInvoke(request, this.target, new Context(dest, src));
            if (r.error == null) continue;
            System.err.println("Invoke response failed:  " + dest.hops[0] + " method " + callback.method + ", " + r.error);
            if (!r.error.equals(RpcError.INVOCATION_EXCEPTION)) continue;
            r.error.data.getValue(Exception.class, null).printStackTrace();
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public void periodicCleanup() {
        int count = this.sessions.size();
        Iterator<AbstractSession> i = this.sessions.values().iterator();
        while (i.hasNext()) {
            AbstractSession session = i.next();
            if (!session.isInvalid()) continue;
            i.remove();
            session.onRemove();
        }
        if (this.sessions.size() < count) {
            System.err.println("INFO: " + this.target.getClass().getSimpleName() + "-" + this.target.hashCode() % 1000 + " cleanup sessions " + count + " -> " + this.sessions.size());
        }
    }

    private AbstractSession getSession(String sessionId, Type type, boolean create) {
        AbstractSession session = null;
        if (sessionId != null) {
            session = this.sessions.get(sessionId);
            if (session != null && session.isInvalid()) {
                this.sessions.remove(sessionId);
                session.onRemove();
                session = null;
            }
            if (session == null) {
                if (create) {
                    try {
                        if (type instanceof ParameterizedType) {
                            type = ((ParameterizedType)type).getRawType();
                        }
                        session = (AbstractSession)((Class)type).newInstance();
                        this.sessions.put(sessionId, session);
                        session.id = sessionId;
                    }
                    catch (ClassCastException e) {
                        e.printStackTrace();
                    }
                    catch (InstantiationException e) {
                        e.printStackTrace();
                    }
                    catch (IllegalAccessException e) {
                        e.printStackTrace();
                    }
                }
            } else if (create) {
                session = null;
            }
        }
        if (session != null) {
            session.lastAccessed = System.currentTimeMillis();
        }
        return session;
    }

    private class CustomParamProcessor
    extends DefaultParamProcessor {
        public CustomParamProcessor(Gson paramDeserializer) {
            super(paramDeserializer);
        }

        @Override
        public Object injectParam(Type paramType, Annotation[] paramAnnotations, Object context) throws ParamValidationException {
            Context c = (Context)context;
            Session sessionAnn = this.findAnnotation(paramAnnotations, Session.class);
            if (sessionAnn != null) {
                ParamType paramTypeAnn = this.findAnnotation(paramAnnotations, ParamType.class);
                AbstractSession session = DefaultRpcHandler.this.getSession(c.dest.hops[0].getFragment(), paramTypeAnn != null ? paramTypeAnn.value() : paramType, sessionAnn.create());
                if (session == null) {
                    throw new InvalidSessionException("Session not found or could not be created");
                }
                return session;
            }
            Dest destAnn = this.findAnnotation(paramAnnotations, Dest.class);
            if (destAnn != null) {
                return c.dest;
            }
            Src srcAnn = this.findAnnotation(paramAnnotations, Src.class);
            if (srcAnn != null) {
                return c.src;
            }
            return super.injectParam(paramType, paramAnnotations, context);
        }
    }

    private static class Context {
        public final Route dest;
        public final Route src;

        public Context(Route dest, Route src) {
            this.dest = dest;
            this.src = src;
        }
    }
}

