/*
 * Decompiled with CFR 0.152.
 */
package eu.memshare.export.main;

import com.google.code.gsonrmi.RpcError;
import com.google.code.gsonrmi.annotations.RMI;
import com.google.code.gsonrmi.annotations.Session;
import com.google.code.gsonrmi.transport.Route;
import com.google.code.gsonrmi.transport.rmi.Call;
import eu.memshare.export.dao.Login_Token;
import eu.memshare.export.dao.MemshareFile;
import eu.memshare.export.dao.MemshareNode;
import eu.memshare.export.dao.NodeFilter;
import eu.memshare.export.dao.SchemaBean;
import eu.memshare.export.dao.Users;
import eu.memshare.export.main.GSONEntity;
import eu.memshare.export.main.GSONSession;
import eu.memshare.export.utils.Enums;
import eu.memshare.export.utils.Utils;
import eu.memshare.filetransfer.FileTransferClient;
import eu.memshare.filetransfer.FileTransferJob;
import eu.memshare.filetransfer.FileTransferStatusListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class ExportGsonClient
extends GSONEntity {
    private static ExportGsonClient instance;
    private static Login_Token token;
    private static String schemaLongName;
    private static String schemaIP;
    private static Users user;

    private ExportGsonClient(String url, String serverName, String clientName, Integer listeningPort) throws InvocationTargetException, URISyntaxException {
        super(url, serverName, clientName, listeningPort);
    }

    protected static ExportGsonClient getFirstInstance(String url, String serverName, String clientName, Integer listeningPort) {
        try {
            System.out.println("Starting connection to worker on ip: " + url);
            System.setProperty("javax.net.ssl.keyStore", "mySrvKeystore");
            System.setProperty("javax.net.ssl.keyStorePassword", "123456");
            System.setProperty("javax.net.ssl.trustStore", "mySrvKeystore");
            System.setProperty("javax.net.ssl.trustStorePassword", "123456");
            instance = new ExportGsonClient(url, serverName, clientName, listeningPort);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        return instance;
    }

    protected void connectToWorkerMainPort(SchemaBean schema) throws URISyntaxException {
        schemaLongName = Utils.escapeForSchema(schema.getLongName());
        schemaIP = schema.getIp();
        this.serverName = "rmi:channelManager";
        this.clientName = "rmi:TestClient";
        this.url = "tcp://" + schema.getIp() + ":" + schema.getPort();
        this.rebuildGSON("TestClient");
    }

    private void connectToWorkerUserPort(SchemaBean schemaBean, Integer port) throws URISyntaxException {
        String user = ExportGsonClient.user.getLogin_name();
        this.serverName = "rmi:" + Utils.buildChannelName(user, port, "server_");
        String clientChannelName = Utils.buildChannelName(user, port, "client_");
        this.clientName = "rmi:" + clientChannelName;
        this.url = "tcp://" + schemaBean.getIp() + ":" + port;
        this.rebuildGSON(clientChannelName);
    }

    protected static synchronized ExportGsonClient getInstance() {
        return instance;
    }

    protected String getSchemaLongName() {
        return schemaLongName;
    }

    protected String getSchemaIP() {
        return schemaIP;
    }

    protected List<SchemaBean> login(String user, String password) {
        token = this.getLoginToken(user, password);
        if (token == null) {
            return null;
        }
        return ExportGsonClient.getInstance().getSchemaForUser();
    }

    protected boolean connectServer(SchemaBean schema) throws URISyntaxException {
        Integer port;
        this.connectToWorkerMainPort(schema);
        user = this.getUserFromWorker();
        if (user != null && (port = this.openChannel(user, schemaLongName)) != null) {
            this.connectToWorkerUserPort(schema, port);
            return true;
        }
        return false;
    }

    protected boolean exportFileForNode(File file, Long key, FileTransferStatusListener listener) throws FileNotFoundException {
        if (file.exists() && file.isFile()) {
            String checksum = Utils.getSha1Checksum(file);
            Long size = file.length();
            System.out.println("Checksum: " + checksum);
            Boolean isExported = this.saveMemshareFile(key, file.getName(), checksum, size, Enums.FileUsage.Attach);
            if (isExported.booleanValue()) {
                FileTransferClient.getInstance().addJob(new FileTransferJob(FileTransferJob.CommandType.UPLOAD_TO_SERVER, file.getPath(), schemaLongName, listener, checksum));
                return true;
            }
        } else {
            throw new FileNotFoundException();
        }
        return false;
    }

    protected void downloadFile(MemshareFile file, File destinationFile, FileTransferStatusListener listener) throws Exception {
        String checksum = file.getChecksum();
        if (checksum == null || checksum.equals("")) {
            throw new Exception("Invalid checksum for MemshareFile.");
        }
        FileTransferClient.getInstance().addJob(new FileTransferJob(FileTransferJob.CommandType.DOWNLOAD_FROM_SERVER, destinationFile.getAbsolutePath(), schemaLongName, listener, checksum));
    }

    private Login_Token getLoginToken(String username, String password) {
        return (Login_Token)this.doServerJob("getLoginByNamePass", "returnLoginToken", username, password);
    }

    protected List<SchemaBean> getSchemaForUser() {
        return (List)this.doServerJob("getAllSchemaForUser", "returnSchemaList", token);
    }

    protected Users getUserFromWorker() {
        return (Users)this.doServerJob("getUserByLoginToken", "returnUser", token, schemaLongName);
    }

    private Integer openChannel(Users user, String schema) {
        return (Integer)this.doServerJob("openChannel", "returnInteger", user, schema);
    }

    protected Boolean keepAlive() {
        return (Boolean)this.doServerJob("keepAlive", "returnBoolean", this.clientName, user.getId());
    }

    protected Long saveMemshareNode(Long id_parent, String node_title) {
        return (Long)this.doServerJob("exportMemshareNode", "returnLong", id_parent, node_title, user.getId(), schemaLongName);
    }

    protected Boolean saveMemshareDescription(Long id_parent, String description) {
        return (Boolean)this.doServerJob("exportMemshareDescription", "returnBoolean", id_parent, description, user.getId(), schemaLongName);
    }

    protected Boolean saveMemshareTags(Long id_node, Map<String, List<String>> tags, boolean replaceOld) {
        return (Boolean)this.doServerJob("exportMemshareTags", "returnBoolean", id_node, tags, replaceOld, user.getId(), schemaLongName);
    }

    protected Boolean saveMemshareMicrosheet(Long node_id, Map<String, List<Map<String, String>>> data, boolean replaceOld) {
        return (Boolean)this.doServerJob("exportMemshareMicrosheets", "returnBoolean", node_id, data, replaceOld, user.getId(), schemaLongName);
    }

    protected Boolean saveMemshareFile(Long node_id, String filename, String checksum, Long size, Enums.FileUsage usage) {
        return (Boolean)this.doServerJob("exportMemshareFile", "returnBoolean", new Object[]{node_id, filename, checksum, size, usage, user.getId(), schemaLongName});
    }

    protected List<MemshareNode> getChildrenNodes(Long node_id, NodeFilter filter) {
        return (List)this.doServerJob("getChildrenNodesAPI", "returnMemshareNodeList", node_id, filter, user.getId(), schemaLongName);
    }

    protected List<MemshareFile> getMemshareFiles(Long node_id) {
        return (List)this.doServerJob("getMemshareFilesAPI", "returnMemshareFileList", node_id, user.getId(), schemaLongName);
    }

    @RMI
    public void returnLoginToken(Login_Token value, @Session GSONSession session, RpcError rpcError) {
        this.processResult(value, session);
    }

    @RMI
    public void returnSchemaList(List<SchemaBean> value, @Session GSONSession session, RpcError rpcError) {
        this.processResult(value, session);
    }

    @RMI
    public void returnMemshareNodeList(List<MemshareNode> value, @Session GSONSession session, RpcError rpcError) {
        this.processResult(value, session);
    }

    @RMI
    public void returnMemshareFileList(List<MemshareFile> value, @Session GSONSession session, RpcError rpcError) {
        this.processResult(value, session);
    }

    @RMI
    public void returnBoolean(Boolean value, @Session GSONSession session, RpcError rpcError) {
        this.processResult(value, session);
    }

    @RMI
    public void returnUser(Users value, @Session GSONSession session, RpcError rpcError) {
        this.processResult(value, session);
    }

    @RMI
    public void returnInteger(Integer value, @Session GSONSession session, RpcError rpcError) {
        this.processResult(value, session);
    }

    @RMI
    public void returnLong(Long value, @Session GSONSession session, RpcError rpcError) {
        this.processResult(value, session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processResult(Object value, GSONSession session) {
        if (value != null) {
            session.setResult(value);
        }
        GSONSession gSONSession = session;
        synchronized (gSONSession) {
            session.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doServerJob(String methodOnServer, String callbackMethod, Object ... params) {
        Object result = null;
        try {
            GSONSession memshareSession = new GSONSession();
            Route to = new Route(new URI(this.url), new URI(this.serverName + "#" + UUID.randomUUID()));
            URI from = new URI(this.clientName);
            Call basic = new Call(to, methodOnServer, params);
            Call returnRoster = basic.callback(from, callbackMethod, new Object[0]).session(memshareSession);
            GSONSession gSONSession = memshareSession;
            synchronized (gSONSession) {
                returnRoster.send(this.transport);
                memshareSession.wait(120000L);
            }
            result = memshareSession.getResult() == null && memshareSession.getRpcError() != null ? null : memshareSession.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    static {
        user = null;
    }
}

