/*
 * Decompiled with CFR 0.152.
 */
package eu.memshare.export.main;

import com.google.code.gsonrmi.Parameter;
import com.google.code.gsonrmi.serializer.ExceptionSerializer;
import com.google.code.gsonrmi.serializer.ParameterSerializer;
import com.google.code.gsonrmi.transport.Route;
import com.google.code.gsonrmi.transport.Transport;
import com.google.code.gsonrmi.transport.rmi.Call;
import com.google.code.gsonrmi.transport.rmi.RmiService;
import com.google.code.gsonrmi.transport.tcp.SecureTcpProxy;
import com.google.code.gsonrmi.transport.tcp.TcpProxy;
import com.google.code.gsonrmi.transport.tcp.TcpProxyFactory;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GSONEntity {
    public String serverName;
    public String clientName;
    public String url;
    private Gson gson;
    public Transport transport;
    public static final long TIMEOUT = 120000L;

    public GSONEntity(String url, String serverName, String clientName, Integer listeningPort) throws InvocationTargetException, URISyntaxException {
        this.url = url;
        this.serverName = serverName;
        this.gson = new GsonBuilder().registerTypeAdapter((Type)((Object)Exception.class), new ExceptionSerializer()).registerTypeAdapter((Type)((Object)Parameter.class), new ParameterSerializer()).create();
        this.transport = new Transport();
        List<InetSocketAddress> listeningAddresses = new ArrayList<InetSocketAddress>();
        if (listeningPort != null) {
            InetSocketAddress inetSocketAddress = new InetSocketAddress(listeningPort);
            listeningAddresses = Arrays.asList(inetSocketAddress);
        }
        TcpProxy tcpProxy = TcpProxyFactory.reflectTcpProxy(SecureTcpProxy.class, listeningAddresses, this.transport, this.gson, null);
        tcpProxy.start();
        RmiService rmiService = new RmiService(this.transport, this.gson);
        rmiService.start();
        this.rebuildGSON(clientName);
        this.serverName = "rmi:" + serverName;
        this.clientName = "rmi:" + clientName;
    }

    public void rebuildGSON(String clientName) throws URISyntaxException {
        URI uri = new URI("rmi:service");
        Route target = new Route(uri);
        Call call = new Call(target, "register", clientName, this);
        call.send(this.transport);
    }
}

