/*
 * Decompiled with CFR 0.152.
 */
package eu.memshare.export.main;

import eu.memshare.export.dao.MemshareFile;
import eu.memshare.export.dao.MemshareNode;
import eu.memshare.export.dao.NodeFilter;
import eu.memshare.export.dao.SchemaBean;
import eu.memshare.export.main.ExportGsonClient;
import eu.memshare.filetransfer.FileTransferStatusListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;

public class MemshareClient {
    private static MemshareClient instance = new MemshareClient();

    private MemshareClient() {
    }

    private boolean validateIp(String ip) {
        return ip.contains("tcp://");
    }

    public static synchronized MemshareClient getInstance() {
        return instance;
    }

    public static String getIpServer() {
        return ExportGsonClient.getInstance().getSchemaIP();
    }

    public Boolean loginAndConnect(String target_ip, String username, String password, String username_owner_storage) throws URISyntaxException {
        List<SchemaBean> schemas = this.login(target_ip, username, password);
        if (schemas != null) {
            for (SchemaBean schema : schemas) {
                String owner_email = schema.getOwner_email();
                if (!owner_email.equals(username_owner_storage)) continue;
                return this.connect(schema);
            }
        }
        return false;
    }

    public List<SchemaBean> login(String target_ip, String user, String password) {
        if (!this.validateIp(target_ip)) {
            return null;
        }
        ExportGsonClient.getFirstInstance(target_ip, "login_server", "TestClient", null);
        return ExportGsonClient.getInstance().login(user, password);
    }

    public Boolean connect(SchemaBean schema) throws URISyntaxException {
        return ExportGsonClient.getInstance().connectServer(schema);
    }

    public boolean connected() {
        return ExportGsonClient.getInstance().getSchemaIP() != null && ExportGsonClient.getInstance().keepAlive() != false;
    }

    public Long saveMemshareNode(Long id_parent, String node_title) {
        return ExportGsonClient.getInstance().saveMemshareNode(id_parent, node_title);
    }

    public Boolean saveMemshareDescription(Long id_node, String description) {
        return ExportGsonClient.getInstance().saveMemshareDescription(id_node, description);
    }

    public Boolean saveMemshareTags(Long id_node, Map<String, List<String>> tags, boolean replaceOld) {
        return ExportGsonClient.getInstance().saveMemshareTags(id_node, tags, replaceOld);
    }

    public Boolean saveMemshareMicrosheet(Long node_id, Map<String, List<Map<String, String>>> data, boolean replaceOld) {
        return ExportGsonClient.getInstance().saveMemshareMicrosheet(node_id, data, replaceOld);
    }

    public Boolean saveMemshareFile(Long node_id, File file, FileTransferStatusListener listener) throws FileNotFoundException {
        return ExportGsonClient.getInstance().exportFileForNode(file, node_id, listener);
    }

    public void downloadMemshareFile(MemshareFile file, File destinationFile, FileTransferStatusListener listener) throws Exception {
        ExportGsonClient.getInstance().downloadFile(file, destinationFile, listener);
    }

    public List<MemshareNode> getChildrenNodes(Long parent_id, NodeFilter filter) {
        return ExportGsonClient.getInstance().getChildrenNodes(parent_id, filter);
    }

    public List<MemshareFile> getMemshareFiles(Long node_id) {
        return ExportGsonClient.getInstance().getMemshareFiles(node_id);
    }

    private static boolean login_example1() {
        boolean connected = false;
        try {
            List<SchemaBean> availableStorages = MemshareClient.getInstance().login("tcp://192.168.1.222:33333", "alex@memshare.eu", "1234");
            connected = MemshareClient.getInstance().connect(availableStorages.get(0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return connected;
    }

    private static boolean login_example2() {
        try {
            return MemshareClient.getInstance().loginAndConnect("tcp://192.168.1.222:33333", "alex@memshare.eu", "1234", "valentin@memshare.eu");
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

