/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.beans;

import com.shfarr.BasicUtils;
import com.shfarr.beans.Property;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class HeavyweightProperty
implements Comparable,
Property {
    protected int level = 0;
    protected Method readMethod = null;
    protected Method writeMethod = null;
    protected String name = null;
    static /* synthetic */ Class class$0;

    public HeavyweightProperty(String name, Class beanClass) {
        this.name = name;
        this.readMethod = HeavyweightProperty.lookupGetter(name, beanClass);
        if (this.readMethod == null) {
            throw new Error("Invalid property! there is no read method");
        }
        this.writeMethod = HeavyweightProperty.lookupSetter(name, beanClass, this.getType());
    }

    public HeavyweightProperty(String name, int level, Method getter, Method setter) {
        this.name = name;
        this.level = level;
        this.readMethod = getter;
        this.writeMethod = setter;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int newLevel) {
        this.level = newLevel;
    }

    public String getName() {
        return this.name;
    }

    public Method getReadMethod() {
        return this.readMethod;
    }

    public void setReadMethod(Method readMethod) {
        this.readMethod = readMethod;
    }

    public Method getWriteMethod() {
        return this.writeMethod;
    }

    public void setWriteMethod(Method writeMethod) {
        this.writeMethod = writeMethod;
    }

    public String toString() {
        return String.valueOf(this.name) + " (" + (this.readMethod != null ? "R" : "") + (this.writeMethod != null ? "W" : "") + ")";
    }

    public Class getType() {
        return this.readMethod != null ? this.readMethod.getReturnType() : this.writeMethod.getParameterTypes()[0];
    }

    public boolean isReadOnly() {
        return this.writeMethod == null;
    }

    public boolean isWriteOnly() {
        return this.readMethod == null;
    }

    public boolean isReadWrite() {
        return !this.isReadOnly() && !this.isWriteOnly();
    }

    public static Method lookupGetter(String property, Class c) {
        String getterMethodName = BasicUtils.changeCase(property, 1);
        String alternativeGetterMethodName = "is" + getterMethodName;
        getterMethodName = "get" + getterMethodName;
        MethodDescriptor[] md = null;
        try {
            BeanInfo bi = Introspector.getBeanInfo(c);
            md = bi.getMethodDescriptors();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < md.length) {
            if ((md[i].getMethod().getName().equals(getterMethodName) || md[i].getMethod().getName().equals(alternativeGetterMethodName)) && md[i].getMethod().getParameterTypes().length == 0 && !md[i].getMethod().getReturnType().equals(Void.TYPE)) {
                return md[i].getMethod();
            }
            ++i;
        }
        return null;
    }

    public static Method lookupSetter(String property, Class c, Class paramType) {
        String setterMethodName = "set" + BasicUtils.changeCase(property, 1);
        MethodDescriptor[] md = null;
        try {
            BeanInfo bi = Introspector.getBeanInfo(c);
            md = bi.getMethodDescriptors();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < md.length) {
            if (md[i].getMethod().getName().equals(setterMethodName) && md[i].getMethod().getParameterTypes().length == 1 && paramType.isAssignableFrom(md[i].getMethod().getParameterTypes()[0]) && md[i].getMethod().getReturnType().equals(Void.TYPE)) {
                return md[i].getMethod();
            }
            ++i;
        }
        return null;
    }

    public int compareTo(Object o) {
        return this.name.compareTo(((HeavyweightProperty)o).getName());
    }

    public Object getValue(Object target) {
        try {
            return this.getReadMethod().invoke(target, null);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(this.getReadMethod() + " / " + target, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(this.getReadMethod() + " / " + target, e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(this.getReadMethod() + " / " + target, e);
        }
    }

    public boolean setValue(Object target, Object value) {
        try {
            this.getWriteMethod().invoke(target, value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean equals(Object o) {
        return o instanceof Property && ((Property)o).getName().equals(this.getName());
    }

    public static String unpackName(String propertyName) {
        StringBuffer result = new StringBuffer();
        int i = 0;
        while (i < propertyName.length()) {
            char c = propertyName.charAt(i);
            if (c >= 'A' && c <= 'Z') {
                if (i != 0) {
                    result.append(' ');
                }
                result.append(c < 'a' ? (char)(c + 32) : c);
            } else if (c == '_') {
                result.append('-');
            } else {
                result.append(c);
            }
            ++i;
        }
        return result.toString();
    }
}

