/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh.textures;

import com.shfarr.ui.plaf.fh.theme.Theme;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.JComponent;

public abstract class Texture {
    public static final byte GRADIENT_TEXTURE_FAMILY = 0;
    public static final byte IMAGE_TEXTURE_FAMILY = 1;
    public static final int ROTATE_0 = 0;
    public static final int ROTATE_90 = 1;
    public static final int ROTATE_180 = 2;
    public static final int ROTATE_270 = 3;
    protected int naturalRotation = 0;
    protected int rotation = 0;
    protected Theme theme = ThemeManager.instance().getCurrentTheme();

    public void setTheme(Theme theme) {
        this.theme = theme;
    }

    public void apply(Shape s, Graphics2D g2D, JComponent c) {
        this.apply(s, null, g2D, c);
    }

    public abstract void apply(Shape var1, Rectangle var2, Graphics2D var3, JComponent var4);

    public abstract void parse(String var1);

    public int getNaturalRotation() {
        return this.naturalRotation;
    }

    public void setNaturalRotation(int naturalRotation) {
        this.naturalRotation = naturalRotation;
    }

    protected int getRotation() {
        return this.rotation;
    }

    protected int actualRotation() {
        return (this.getNaturalRotation() + this.getRotation()) % 4;
    }

    public void rotate(int rotation) {
        this.rotation += rotation;
    }
}

