/*
 * Decompiled with CFR 0.152.
 */
package com.shfarr.ui.plaf.fh.theme.edit;

import com.shfarr.ui.plaf.fh.theme.Theme;
import com.shfarr.ui.plaf.fh.theme.ThemeManager;
import com.shfarr.ui.plaf.fh.theme.edit.ColorEditor;
import com.shfarr.ui.plaf.fh.theme.edit.FontEditor;
import com.shfarr.ui.plaf.fh.theme.edit.GeneralEditor;
import com.shfarr.ui.plaf.fh.theme.edit.MatrixEditor;
import com.shfarr.ui.plaf.fh.theme.edit.TextureEditor;
import javax.swing.JLabel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ThemeEditor
extends JTabbedPane
implements ChangeListener {
    private Theme editedTheme = null;
    private static ThemeEditor currentEditor = null;
    private int componentCount = 0;

    ThemeEditor() {
        this.addChangeListener(this);
    }

    public Theme getEditedTheme() {
        if (this.editedTheme == null || !this.editedTheme.getName().equals(ThemeManager.instance().getPreferences().getCurrentTheme())) {
            try {
                this.editedTheme = new Theme(ThemeManager.instance().getPreferences().getCurrentTheme());
                this.editedTheme.addChangeListener(ThemeManager.instance());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.editedTheme;
    }

    public static ThemeEditor instance() {
        if (currentEditor == null) {
            currentEditor = new ThemeEditor();
            currentEditor.addTab("General", new GeneralEditor());
            currentEditor.addTab("Colors", new JLabel());
            currentEditor.addTab("Fonts", new JLabel());
            currentEditor.addTab("Matrices", new JLabel());
            currentEditor.addTab("Textures", new JLabel());
        }
        return currentEditor;
    }

    public void stateChanged(ChangeEvent e) {
        if (this.getSelectedIndex() == 1 && !(this.getSelectedComponent() instanceof ColorEditor)) {
            currentEditor.setComponentAt(1, new ColorEditor());
            ++this.componentCount;
        } else if (this.getSelectedIndex() == 2 && !(this.getSelectedComponent() instanceof FontEditor)) {
            currentEditor.setComponentAt(2, new FontEditor());
            ++this.componentCount;
        } else if (this.getSelectedIndex() == 3 && !(this.getSelectedComponent() instanceof MatrixEditor)) {
            currentEditor.setComponentAt(3, new MatrixEditor());
            ++this.componentCount;
        } else if (this.getSelectedIndex() == 4 && !(this.getSelectedComponent() instanceof TextureEditor)) {
            currentEditor.setComponentAt(4, new TextureEditor());
            ++this.componentCount;
        }
        if (this.componentCount == 4) {
            this.removeChangeListener(this);
        }
    }
}

