/*
 * Decompiled with CFR 0.152.
 */
package mseries.ui;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Calendar;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.Calendar.MFieldListener;
import mseries.ui.MChangeEvent;
import mseries.ui.MChangeListener;
import mseries.ui.MDateEntryField;

public class MDateEntryFieldDemo2
implements Runnable {
    JFrame frame;
    private ButtonGroup lafMenuGroup = new ButtonGroup();

    public static void main(String[] argv) {
        MDateEntryFieldDemo2 demo = new MDateEntryFieldDemo2();
        demo.run();
    }

    public void run() {
        this.frame = new JFrame("Test Window ");
        this.frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        this.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        Calendar cx = Calendar.getInstance();
        cx.set(2001, 5, 12);
        final MDateEntryField entryField = new MDateEntryField(10);
        MDefaultPullDownConstraints c = new MDefaultPullDownConstraints();
        c.firstDay = 2;
        c.changerStyle = 4;
        c.hasShadow = true;
        entryField.setConstraints(c);
        entryField.addMFieldListener(new MFieldListener(){

            public void fieldEntered(FocusEvent e) {
                System.out.println("MDateEntryField:Entered");
            }

            public void fieldExited(FocusEvent e) {
                System.out.println("MDateEntryField:Exited");
                try {
                    System.out.println("EE " + entryField.getValue());
                }
                catch (Exception ee) {
                    System.out.println(ee);
                }
            }
        });
        entryField.addMChangeListener(new MChangeListener(){

            public void valueChanged(MChangeEvent e) {
                System.out.println(e.getValue());
            }
        });
        entryField.setToolTipText("Click the button");
        GridLayout l = new GridLayout(3, 4, 7, 7);
        JPanel displayPanel = new JPanel(l);
        displayPanel.add(new JLabel("MDateEntryField"));
        displayPanel.add(entryField);
        this.frame.getContentPane().setLayout(new FlowLayout());
        this.frame.getContentPane().add(displayPanel);
        this.frame.pack();
        this.frame.show();
    }

    public JMenuBar createMenus() {
        JMenuBar menuBar = new JMenuBar();
        UIManager.LookAndFeelInfo[] lafs = UIManager.getInstalledLookAndFeels();
        if (lafs.length <= 0) {
            return menuBar;
        }
        JMenu lafMenu = menuBar.add(new JMenu("Look & Feel"));
        lafMenu.setMnemonic('L');
        int i = 0;
        while (i < lafs.length) {
            UIManager.LookAndFeelInfo laf = lafs[i];
            String lafName = laf.getName();
            String lafClassName = laf.getClassName();
            this.createLafMenuItem(lafMenu, lafName, "", lafClassName);
            ++i;
        }
        return menuBar;
    }

    public JMenuItem createLafMenuItem(JMenu menu, String label, String mnemonic, String laf) {
        JMenuItem mi = menu.add(new JRadioButtonMenuItem(label));
        this.lafMenuGroup.add(mi);
        mi.addActionListener(new ChangeLookAndFeelAction(this, laf));
        return mi;
    }

    public void setLookAndFeel(String laf) {
        try {
            UIManager.setLookAndFeel(laf);
            SwingUtilities.updateComponentTreeUI(this.frame);
            this.frame.pack();
        }
        catch (Exception ex) {
            System.out.println("Failed loading L&F: " + laf);
            System.out.println(ex);
        }
    }

    class ChangeLookAndFeelAction
    implements ActionListener {
        MDateEntryFieldDemo2 m;
        String laf;

        public ChangeLookAndFeelAction(MDateEntryFieldDemo2 d, String laf) {
            this.m = d;
            this.laf = laf;
        }

        public void actionPerformed(ActionEvent e) {
            this.m.setLookAndFeel(this.laf);
        }
    }
}

