/*
 * Decompiled with CFR 0.152.
 */
package Aladdin;

import Aladdin.HaspTime;

public class Hasp {
    private int[] handle = new int[]{0};
    private long featureid;
    private int status = 0;
    public static final String HASP_UPDATEINFO = new String("<haspformat format=\"updateinfo\"/>\u0000");
    public static final String HASP_SESSIONINFO = new String("<haspformat format=\"sessioninfo\"/>\u0000");
    public static final String HASP_KEYINFO = new String("<haspformat format=\"keyinfo\"/>\u0000");
    public static final long HASP_FEATURETYPE_MASK = -65536L;
    public static final long HASP_PROGNUM_FEATURETYPE = -65536L;
    public static final long HASP_PROGNUM_MASK = 255L;
    public static final long HASP_PROGNUM_OPT_MASK = 65280L;
    public static final long HASP_PROGNUM_OPT_NO_LOCAL = 32768L;
    public static final long HASP_PROGNUM_OPT_NO_REMOTE = 16384L;
    public static final long HASP_PROGNUM_OPT_PROCESS = 8192L;
    public static final long HASP_PROGNUM_OPT_CLASSIC = 4096L;
    public static final long HASP_PROGNUM_OPT_TS = 2048L;
    public static final long HASP_DEFAULT_FID = 0L;
    public static final long HASP_PROGNUM_DEFAULT_FID = -65536L;
    public static final int HASP_MIN_BLOCK_SIZE = 16;
    public static final long HASP_MIN_BLOCK_SIZE_LEGACY = 8L;
    public static final int HASP_FILEID_MAIN = 65520;
    public static final long HASP_FILEID_LICENSE = 65522L;

    public int getLastError() {
        return this.status;
    }

    private static native int Login(long var0, byte[] var2, int[] var3);

    private static native int Logout(int var0);

    private static native int Encrypt(int var0, byte[] var1, int var2);

    private static native int Decrypt(int var0, byte[] var1, int var2);

    private static native int GetRtc(int var0, long[] var1);

    private static native byte[] GetSessioninfo(int var0, byte[] var1, int[] var2);

    private static native void Free(long var0);

    private static native byte[] Update(byte[] var0, int[] var1);

    private static native int Read(int var0, int var1, int var2, int var3, byte[] var4);

    private static native int Write(int var0, int var1, int var2, int var3, byte[] var4);

    private static native int GetSize(int var0, int var1, int[] var2);

    public Hasp(long feature_id) {
        this.featureid = feature_id;
        this.handle[0] = 0;
    }

    public boolean login(String vendor_code) {
        this.status = Hasp.Login(this.featureid, vendor_code.getBytes(), this.handle);
        return this.status == 0;
    }

    public boolean logout() {
        this.status = Hasp.Logout(this.handle[0]);
        return this.status == 0;
    }

    public boolean encrypt(byte[] buffer, int length) {
        this.status = Hasp.Encrypt(this.handle[0], buffer, length);
        return this.status == 0;
    }

    public boolean decrypt(byte[] buffer, int length) {
        this.status = Hasp.Decrypt(this.handle[0], buffer, length);
        return this.status == 0;
    }

    public String getSessionInfo(String format) {
        byte[] info = new byte[]{0};
        int[] status1 = new int[]{0};
        String s = null;
        info = Hasp.GetSessioninfo(this.handle[0], format.getBytes(), status1);
        this.status = status1[0];
        if (this.status == 0) {
            s = new String(info);
        }
        return s;
    }

    public boolean read(int fileid, int offset, int length, byte[] buffer) {
        this.status = Hasp.Read(this.handle[0], fileid, offset, length, buffer);
        return this.status == 0;
    }

    public boolean write(int fileid, int offset, int length, byte[] buffer) {
        this.status = Hasp.Write(this.handle[0], fileid, offset, length, buffer);
        return this.status == 0;
    }

    public int getSize(int fileid) {
        int[] size = new int[]{0};
        this.status = Hasp.GetSize(this.handle[0], fileid, size);
        return size[0];
    }

    public String update(byte[] update_data) {
        byte[] ack_data = new byte[]{0};
        int[] dll_status = new int[]{0};
        String s = null;
        ack_data = Hasp.Update(update_data, dll_status);
        this.status = dll_status[0];
        if (this.status == 0 && ack_data != null) {
            s = new String(ack_data);
        }
        return s;
    }

    public HaspTime getRealTimeClock() {
        long[] time = new long[]{0L};
        this.status = Hasp.GetRtc(this.handle[0], time);
        HaspTime rtcTime = new HaspTime(time[0]);
        if (this.status == 0) {
            this.status = rtcTime.getLastError();
        }
        return rtcTime;
    }

    static {
        System.loadLibrary("HASPJava");
    }
}

