/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi;

import com.google.code.gsonrmi.ParamValidationException;
import com.google.code.gsonrmi.Parameter;
import com.google.code.gsonrmi.RpcError;
import com.google.code.gsonrmi.RpcRequest;
import com.google.code.gsonrmi.RpcResponse;
import com.google.code.gsonrmi.annotations.RMI;
import com.google.gson.JsonParseException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class Invoker {
    private final ParamProcessor paramProcessor;

    public Invoker(ParamProcessor paramProcessor) {
        this.paramProcessor = paramProcessor;
    }

    public RpcResponse doInvoke(RpcRequest request, Object target, Object context) {
        RpcResponse response = new RpcResponse();
        response.id = request.id;
        try {
            Method m;
            Parameter[] params;
            Parameter[] parameterArray = params = request.params != null ? request.params : new Parameter[]{};
            if (request.method.equals("ack")) {
                System.out.println();
            }
            if ((m = this.findMethod(target, request.method, params)) == null) {
                throw new NoSuchMethodException(request.method);
            }
            Type[] paramTypes = m.getGenericParameterTypes();
            Annotation[][] paramAnnotations = m.getParameterAnnotations();
            Object[] processedParams = new Object[paramTypes.length];
            int j = 0;
            for (int i = 0; i < processedParams.length; ++i) {
                processedParams[i] = this.paramProcessor.isInjectedParam(paramAnnotations[i]) ? this.paramProcessor.injectParam(paramTypes[i], paramAnnotations[i], context) : this.paramProcessor.processParam(params[j++], paramTypes[i], paramAnnotations[i], context);
            }
            Object returnValue = m.invoke(target, processedParams);
            response.result = returnValue != null ? new Parameter(returnValue) : null;
        }
        catch (JsonParseException e) {
            response.error = RpcError.PARSER_ERROR;
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            response.error = new RpcError(RpcError.INVOCATION_EXCEPTION, e.getCause());
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            response.error = RpcError.METHOD_NOT_FOUND;
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            response.error = RpcError.INVALID_PARAMS;
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            response.error = RpcError.METHOD_NOT_FOUND;
            e.printStackTrace();
        }
        catch (ParamValidationException e) {
            response.error = new RpcError(RpcError.PARAM_VALIDATION_FAILED, (Object)e.getMessage());
            e.printStackTrace();
        }
        return response;
    }

    public Method findMethod(Object target, String method, Parameter[] params) {
        for (Method m : target.getClass().getMethods()) {
            RMI rmi = m.getAnnotation(RMI.class);
            if (rmi == null) continue;
            String rmiName = rmi.value();
            if (rmiName.isEmpty()) {
                rmiName = m.getName();
            }
            if (!rmiName.equals(method)) continue;
            int countInjects = 0;
            for (Annotation[] a : m.getParameterAnnotations()) {
                if (!this.paramProcessor.isInjectedParam(a)) continue;
                ++countInjects;
            }
            if (params.length + countInjects != m.getParameterTypes().length) continue;
            return m;
        }
        return null;
    }

    public static interface ParamProcessor {
        public boolean isInjectedParam(Annotation[] var1);

        public Object injectParam(Type var1, Annotation[] var2, Object var3) throws ParamValidationException;

        public Object processParam(Parameter var1, Type var2, Annotation[] var3, Object var4) throws ParamValidationException;
    }
}

