/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.transport;

import com.google.code.gsonrmi.Parameter;
import com.google.code.gsonrmi.transport.Collections;
import java.net.URI;
import java.util.Arrays;

public class Route
implements Collections.Groupable<String> {
    public final URI[] hops;
    public final Parameter trackingId;

    public Route(URI ... hops) {
        this((Object)null, hops);
    }

    public Route(Object trackingId, URI ... hops) {
        this.trackingId = new Parameter(trackingId);
        this.hops = hops;
    }

    public Route addFirst(URI ... hops) {
        URI[] out = Arrays.copyOf(hops, hops.length + this.hops.length);
        for (int i = 0; i < this.hops.length; ++i) {
            out[hops.length + i] = this.hops[i];
        }
        return new Route(this.trackingId, out);
    }

    public Route removeFirst() {
        return new Route(this.trackingId, Arrays.copyOfRange(this.hops, 1, this.hops.length));
    }

    public boolean isEmpty() {
        return this.hops.length == 0;
    }

    @Override
    public String getGroupKey(Object groupBy) {
        if (GroupBy.SCHEME.equals(groupBy)) {
            return this.hops.length == 0 ? null : this.hops[0].getScheme();
        }
        if (GroupBy.AUTHORITY.equals(groupBy)) {
            return this.hops.length == 0 ? null : this.hops[0].getAuthority();
        }
        return null;
    }

    public static enum GroupBy {
        SCHEME,
        AUTHORITY;

    }
}

