/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.transport.http;

import com.google.code.gsonrmi.RpcError;
import com.google.code.gsonrmi.RpcRequest;
import com.google.code.gsonrmi.RpcResponse;
import com.google.code.gsonrmi.transport.Message;
import com.google.code.gsonrmi.transport.MessageProcessor;
import com.google.code.gsonrmi.transport.Route;
import com.google.code.gsonrmi.transport.Transport;
import com.google.code.gsonrmi.transport.http.HttpError;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class HttpClient
extends MessageProcessor {
    private final Transport t;
    private final Gson gson;
    private final Executor exec;

    public HttpClient(Transport transport, Gson serializer, Executor executor) {
        this.t = transport;
        this.gson = serializer;
        this.exec = executor;
    }

    @Override
    protected void process(Message m) {
        if (m.contentOfType(Transport.Shutdown.class)) {
            this.handle(m.getContentAs(Transport.Shutdown.class, this.gson));
        } else {
            this.exec.execute(new Task(m));
        }
    }

    private void handle(Transport.Shutdown m) {
        if (this.exec instanceof ExecutorService) {
            ((ExecutorService)this.exec).shutdown();
        }
    }

    private class Task
    implements Runnable {
        private Message m;

        public Task(Message message) {
            this.m = message;
        }

        @Override
        public void run() {
            for (Route dest : this.m.dests) {
                RpcResponse response;
                try {
                    URL requestUrl = dest.hops[0].toURL();
                    HttpURLConnection con = (HttpURLConnection)requestUrl.openConnection();
                    con.setRequestMethod("POST");
                    con.setRequestProperty("Content-Type", "application/json");
                    con.setRequestProperty("Content-Class", this.m.contentType);
                    con.setDoOutput(true);
                    con.getOutputStream().write(this.m.content.getSerializedValue(HttpClient.this.gson).toString().getBytes("utf-8"));
                    int responseCode = con.getResponseCode();
                    if (responseCode == 200) {
                        response = HttpClient.this.gson.fromJson((Reader)new InputStreamReader(con.getInputStream(), "utf-8"), RpcResponse.class);
                    } else {
                        RpcRequest request = this.m.content.getValue(RpcRequest.class, HttpClient.this.gson);
                        response = new RpcResponse();
                        response.id = request.id;
                        response.error = new RpcError(HttpError.HTTP_REQUEST_FAILED, (Object)(responseCode + " " + con.getResponseMessage()));
                    }
                }
                catch (IOException e) {
                    RpcRequest request = this.m.content.getValue(RpcRequest.class, HttpClient.this.gson);
                    response = new RpcResponse();
                    response.id = request.id;
                    response.error = new RpcError(HttpError.IO_EXCEPTION, e);
                }
                HttpClient.this.t.send(new Message(dest, Arrays.asList(this.m.src), response));
            }
        }
    }
}

