/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.gsonrmi.transport.rmi;

import com.google.code.gsonrmi.Parameter;
import com.google.code.gsonrmi.RpcError;
import com.google.code.gsonrmi.RpcRequest;
import com.google.code.gsonrmi.RpcResponse;
import com.google.code.gsonrmi.annotations.RMI;
import com.google.code.gsonrmi.transport.DeliveryFailure;
import com.google.code.gsonrmi.transport.Message;
import com.google.code.gsonrmi.transport.MessageProcessor;
import com.google.code.gsonrmi.transport.Proxy;
import com.google.code.gsonrmi.transport.Route;
import com.google.code.gsonrmi.transport.Transport;
import com.google.code.gsonrmi.transport.rmi.Call;
import com.google.code.gsonrmi.transport.rmi.Callback;
import com.google.code.gsonrmi.transport.rmi.DefaultRpcHandler;
import com.google.code.gsonrmi.transport.rmi.RmiError;
import com.google.code.gsonrmi.transport.rmi.RpcHandler;
import com.google.gson.Gson;
import com.google.gson.JsonPrimitive;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TimerTask;

public class RmiService
extends MessageProcessor {
    public static final String SCHEME = "rmi";
    private final URI addr = new URI("rmi", "service", null);
    private final Transport t;
    private final Gson gson;
    private final Map<String, RpcHandler> handlers;
    private final Map<Integer, Call> pendingCalls;
    private final TimerTask cleanupTask;
    private int idGen;

    public RmiService(Transport transport, Gson deserializer) throws URISyntaxException {
        this(transport, deserializer, new Options());
    }

    public RmiService(Transport transport, Gson deserializer, Options options) throws URISyntaxException {
        this.t = transport;
        this.t.register(SCHEME, this.mq);
        this.gson = deserializer;
        this.handlers = new HashMap<String, RpcHandler>();
        this.handlers.put(this.addr.getSchemeSpecificPart(), new DefaultRpcHandler(this, this.gson));
        this.pendingCalls = new HashMap<Integer, Call>();
        this.cleanupTask = new Call(new Route(this.addr), "periodicCleanup", new Object[0]).sendEvery(this.t, options.cleanupInterval, options.cleanupInterval);
    }

    @RMI
    public URI register(String id, Object target) throws URISyntaxException {
        if (target instanceof RpcHandler) {
            this.handlers.put(id, (RpcHandler)target);
        } else {
            this.handlers.put(id, new DefaultRpcHandler(target, this.gson));
        }
        return new URI(SCHEME, id, null);
    }

    @Override
    protected void process(Message m) {
        if (m.contentOfType(Call.class)) {
            this.handle(m.getContentAs(Call.class, this.gson));
        } else if (m.contentOfType(RpcRequest.class)) {
            this.handle(m.getContentAs(RpcRequest.class, this.gson), m.dests, m.src);
        } else if (m.contentOfType(RpcResponse.class)) {
            this.handle(m.getContentAs(RpcResponse.class, this.gson), m.dests.get(0), Arrays.asList(m.src));
        } else if (m.contentOfType(DeliveryFailure.class)) {
            this.handle(m.getContentAs(DeliveryFailure.class, this.gson), m.dests.get(0), m.src);
        } else if (m.contentOfType(Transport.Shutdown.class)) {
            this.handle(m.getContentAs(Transport.Shutdown.class, this.gson));
        } else if (!m.contentOfType(Proxy.CheckConnection.class) && !m.contentOfType(Proxy.OnConnectionClosed.class)) {
            System.err.println("Unhandled message type: " + m.contentType);
        }
    }

    private void handle(Call m) {
        m.timeSent = System.currentTimeMillis();
        if ("_onConnectionClosed".equals(m.method)) {
            if (m.params.length != 0) {
                System.err.println("WARN: _onConnectionClosed accepts no params");
            }
            if (m.callback != null) {
                Proxy.OnConnectionClosed request = new Proxy.OnConnectionClosed();
                Parameter[] data = Arrays.copyOf(m.callback.params, m.callback.params.length + 1);
                data[data.length - 1] = new Parameter(m.callback.method);
                request.data = new Parameter(data);
                this.t.send(new Message(m.callback.target, m.targets, request));
            } else {
                System.err.println("_onConnectionClosed requires a callback");
            }
        } else {
            Integer id = null;
            if (m.callback != null) {
                id = ++this.idGen;
                this.pendingCalls.put(id, m);
            }
            if ("_checkConnection".equals(m.method)) {
                if (m.callback != null) {
                    Proxy.CheckConnection request = new Proxy.CheckConnection();
                    request.data = new Parameter(id);
                    this.t.send(new Message(m.callback.target, m.targets, request));
                } else {
                    System.err.println("_checkConnection requires a callback");
                }
            } else {
                RpcRequest request = new RpcRequest();
                request.method = m.method;
                request.params = m.params;
                request.id = id != null ? new Parameter(id) : null;
                this.t.send(new Message(m.callback != null ? m.callback.target : new Route(this.addr), m.targets, request));
            }
        }
    }

    private void handle(RpcRequest request, List<Route> dests, Route src) {
        for (Route dest : dests) {
            RpcResponse response;
            RpcHandler handler;
            URI targetUri = dest.hops[0];
            if (request.method.equals("registerCapabilities")) {
                for (int i = 0; i < request.params.length; ++i) {
                    System.out.println(request.params[i]);
                    if (request.params[i] != null) continue;
                    String host = src.hops[0].getAuthority();
                    JsonPrimitive o = new JsonPrimitive(host);
                    request.params[i] = new Parameter(o);
                }
            }
            if ((handler = this.handlers.get(targetUri.getSchemeSpecificPart())) != null) {
                response = handler.handle(request, dest, src);
            } else {
                response = new RpcResponse();
                response.id = request.id;
                response.error = new RpcError(RmiError.TARGET_NOT_FOUND, targetUri);
            }
            if (response == null) continue;
            if (response.id != null) {
                this.t.send(new Message(dest, Arrays.asList(src), response));
                continue;
            }
            if (response.error == null) continue;
            System.err.println("Notification failed:  " + targetUri + " method " + request.method + ", " + response.error);
            if (!response.error.equals(RpcError.INVOCATION_EXCEPTION)) continue;
            response.error.data.getValue(Exception.class, this.gson).printStackTrace();
        }
    }

    private void handle(RpcResponse response, Route dest, List<Route> srcs) {
        Integer responseId = response.id.getValue(Integer.class, this.gson);
        Call pendingCall = this.pendingCalls.get(responseId);
        if (pendingCall != null) {
            this.invokeCallback(pendingCall.callback, response, dest, srcs);
        } else {
            System.err.println("No pending request with id " + responseId);
        }
    }

    private void handle(DeliveryFailure m, Route dest, Route src) {
        if (m.message.contentOfType(RpcRequest.class)) {
            RpcRequest request = m.message.getContentAs(RpcRequest.class, this.gson);
            if (request.id != null) {
                RpcResponse response = new RpcResponse();
                response.id = request.id;
                response.error = RmiError.UNREACHABLE;
                this.handle(response, dest, this.prependToEach(m.message.dests, src));
            } else {
                System.err.println("Failed to deliver notification(s): " + request.method);
            }
        } else if (m.message.contentOfType(RpcResponse.class)) {
            RpcResponse response = m.message.getContentAs(RpcResponse.class, this.gson);
            Integer responseId = response.id.getValue(Integer.class, this.gson);
            System.err.println("Failed to deliver response with id " + responseId);
        } else if (m.message.contentOfType(Proxy.CheckConnection.class)) {
            Proxy.CheckConnection request = m.message.getContentAs(Proxy.CheckConnection.class, this.gson);
            RpcResponse response = new RpcResponse();
            response.id = request.data;
            response.error = RmiError.UNREACHABLE;
            this.handle(response, dest, this.prependToEach(m.message.dests, src));
        } else if (m.message.contentOfType(Proxy.OnConnectionClosed.class)) {
            Proxy.OnConnectionClosed request = m.message.getContentAs(Proxy.OnConnectionClosed.class, this.gson);
            Callback callback = new Callback();
            callback.target = dest;
            Parameter[] data = request.data.getValue(Parameter[].class, this.gson);
            callback.method = data[data.length - 1].getValue(String.class, this.gson);
            callback.params = Arrays.copyOfRange(data, 0, data.length - 1);
            RpcResponse response = new RpcResponse();
            response.error = RmiError.UNREACHABLE;
            this.invokeCallback(callback, response, dest, this.prependToEach(m.message.dests, src));
        } else {
            System.err.println("Unhandled delivery failure of " + m.message.contentType);
        }
    }

    private void handle(Transport.Shutdown m) {
        for (RpcHandler handler : this.handlers.values()) {
            handler.shutdown();
        }
        this.cleanupTask.cancel();
    }

    @RMI
    public void periodicCleanup() {
        int count = this.pendingCalls.size();
        Iterator<Call> i = this.pendingCalls.values().iterator();
        while (i.hasNext()) {
            if (!i.next().isExpired()) continue;
            i.remove();
        }
        if (this.pendingCalls.size() < count) {
            System.err.println("INFO: cleanup pending calls " + count + " -> " + this.pendingCalls.size());
        }
        for (RpcHandler h : this.handlers.values()) {
            h.periodicCleanup();
        }
    }

    private List<Route> prependToEach(List<Route> dests, Route src) {
        LinkedList<Route> out = new LinkedList<Route>();
        for (Route dest : dests) {
            out.add(dest.addFirst(src.hops));
        }
        return out;
    }

    private void invokeCallback(Callback callback, RpcResponse response, Route dest, List<Route> srcs) {
        URI targetUri = dest.hops[0];
        RpcHandler handler = this.handlers.get(targetUri.getSchemeSpecificPart());
        if (handler != null) {
            handler.handle(response, dest, srcs, callback);
        } else {
            System.err.println("Callback target not found " + targetUri);
        }
    }

    public static class Options {
        public long cleanupInterval = 60000L;
    }
}

