/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.stmt;

import com.j256.ormlite.dao.CloseableIterator;
import com.j256.ormlite.dao.Dao;
import com.j256.ormlite.dao.GenericRawResults;
import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.stmt.ArgumentHolder;
import com.j256.ormlite.stmt.PreparedQuery;
import com.j256.ormlite.stmt.PreparedStmt;
import com.j256.ormlite.stmt.QueryBuilder;
import com.j256.ormlite.stmt.StatementBuilder;
import com.j256.ormlite.stmt.query.Between;
import com.j256.ormlite.stmt.query.Clause;
import com.j256.ormlite.stmt.query.Exists;
import com.j256.ormlite.stmt.query.In;
import com.j256.ormlite.stmt.query.InSubQuery;
import com.j256.ormlite.stmt.query.IsNotNull;
import com.j256.ormlite.stmt.query.IsNull;
import com.j256.ormlite.stmt.query.ManyClause;
import com.j256.ormlite.stmt.query.NeedsFutureClause;
import com.j256.ormlite.stmt.query.Not;
import com.j256.ormlite.stmt.query.Raw;
import com.j256.ormlite.stmt.query.SimpleComparison;
import com.j256.ormlite.table.TableInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class Where<T, ID> {
    private static final int START_CLAUSE_SIZE = 4;
    private final TableInfo<T, ID> tableInfo;
    private final StatementBuilder<T, ID> statementBuilder;
    private final FieldType idFieldType;
    private final String idColumnName;
    private final DatabaseType databaseType;
    private Clause[] clauseStack = new Clause[4];
    private int clauseStackLevel = 0;
    private NeedsFutureClause needsFuture = null;

    Where(TableInfo<T, ID> tableInfo, StatementBuilder<T, ID> statementBuilder, DatabaseType databaseType) {
        this.tableInfo = tableInfo;
        this.statementBuilder = statementBuilder;
        this.idFieldType = tableInfo.getIdField();
        this.idColumnName = this.idFieldType == null ? null : this.idFieldType.getColumnName();
        this.databaseType = databaseType;
    }

    public Where<T, ID> and() {
        this.addNeedsFuture(new ManyClause(this.pop("AND"), "AND"));
        return this;
    }

    public Where<T, ID> and(Where<T, ID> first, Where<T, ID> second, Where<T, ID> ... others) {
        Clause[] clauses = this.buildClauseArray(others, "AND");
        Clause secondClause = this.pop("AND");
        Clause firstClause = this.pop("AND");
        this.addClause(new ManyClause(firstClause, secondClause, clauses, "AND"));
        return this;
    }

    public Where<T, ID> and(int numClauses) {
        if (numClauses == 0) {
            throw new IllegalArgumentException("Must have at least one clause in and(numClauses)");
        }
        Clause[] clauses = new Clause[numClauses];
        for (int i = numClauses - 1; i >= 0; --i) {
            clauses[i] = this.pop("AND");
        }
        this.addClause(new ManyClause(clauses, "AND"));
        return this;
    }

    public Where<T, ID> between(String columnName, Object low, Object high) throws SQLException {
        this.addClause(new Between(columnName, this.findColumnFieldType(columnName), low, high));
        return this;
    }

    public Where<T, ID> eq(String columnName, Object value) throws SQLException {
        this.addClause(new SimpleComparison(columnName, this.findColumnFieldType(columnName), value, "="));
        return this;
    }

    public Where<T, ID> ge(String columnName, Object value) throws SQLException {
        this.addClause(new SimpleComparison(columnName, this.findColumnFieldType(columnName), value, ">="));
        return this;
    }

    public Where<T, ID> gt(String columnName, Object value) throws SQLException {
        this.addClause(new SimpleComparison(columnName, this.findColumnFieldType(columnName), value, ">"));
        return this;
    }

    public Where<T, ID> in(String columnName, Iterable<?> objects) throws SQLException {
        this.addClause(new In(columnName, this.findColumnFieldType(columnName), objects, true));
        return this;
    }

    public Where<T, ID> notIn(String columnName, Iterable<?> objects) throws SQLException {
        this.addClause(new In(columnName, this.findColumnFieldType(columnName), objects, false));
        return this;
    }

    public Where<T, ID> in(String columnName, Object ... objects) throws SQLException {
        return this.in(true, columnName, objects);
    }

    public Where<T, ID> notIn(String columnName, Object ... objects) throws SQLException {
        return this.in(false, columnName, objects);
    }

    public Where<T, ID> in(String columnName, QueryBuilder<?, ?> subQueryBuilder) throws SQLException {
        return this.in(true, columnName, subQueryBuilder);
    }

    public Where<T, ID> notIn(String columnName, QueryBuilder<?, ?> subQueryBuilder) throws SQLException {
        return this.in(false, columnName, subQueryBuilder);
    }

    public Where<T, ID> exists(QueryBuilder<?, ?> subQueryBuilder) {
        subQueryBuilder.enableInnerQuery();
        this.addClause(new Exists(new QueryBuilder.InternalQueryBuilderWrapper(subQueryBuilder)));
        return this;
    }

    public Where<T, ID> isNull(String columnName) throws SQLException {
        this.addClause(new IsNull(columnName, this.findColumnFieldType(columnName)));
        return this;
    }

    public Where<T, ID> isNotNull(String columnName) throws SQLException {
        this.addClause(new IsNotNull(columnName, this.findColumnFieldType(columnName)));
        return this;
    }

    public Where<T, ID> le(String columnName, Object value) throws SQLException {
        this.addClause(new SimpleComparison(columnName, this.findColumnFieldType(columnName), value, "<="));
        return this;
    }

    public Where<T, ID> lt(String columnName, Object value) throws SQLException {
        this.addClause(new SimpleComparison(columnName, this.findColumnFieldType(columnName), value, "<"));
        return this;
    }

    public Where<T, ID> like(String columnName, Object value) throws SQLException {
        this.addClause(new SimpleComparison(columnName, this.findColumnFieldType(columnName), value, "LIKE"));
        return this;
    }

    public Where<T, ID> ne(String columnName, Object value) throws SQLException {
        this.addClause(new SimpleComparison(columnName, this.findColumnFieldType(columnName), value, "<>"));
        return this;
    }

    public Where<T, ID> not() {
        this.addNeedsFuture(new Not());
        return this;
    }

    public Where<T, ID> not(Where<T, ID> comparison) {
        this.addClause(new Not(this.pop("NOT")));
        return this;
    }

    public Where<T, ID> or() {
        this.addNeedsFuture(new ManyClause(this.pop("OR"), "OR"));
        return this;
    }

    public Where<T, ID> or(Where<T, ID> left, Where<T, ID> right, Where<T, ID> ... others) {
        Clause[] clauses = this.buildClauseArray(others, "OR");
        Clause secondClause = this.pop("OR");
        Clause firstClause = this.pop("OR");
        this.addClause(new ManyClause(firstClause, secondClause, clauses, "OR"));
        return this;
    }

    public Where<T, ID> or(int numClauses) {
        if (numClauses == 0) {
            throw new IllegalArgumentException("Must have at least one clause in or(numClauses)");
        }
        Clause[] clauses = new Clause[numClauses];
        for (int i = numClauses - 1; i >= 0; --i) {
            clauses[i] = this.pop("OR");
        }
        this.addClause(new ManyClause(clauses, "OR"));
        return this;
    }

    public Where<T, ID> idEq(ID id) throws SQLException {
        if (this.idColumnName == null) {
            throw new SQLException("Object has no id column specified");
        }
        this.addClause(new SimpleComparison(this.idColumnName, this.idFieldType, id, "="));
        return this;
    }

    public <OD> Where<T, ID> idEq(Dao<OD, ?> dataDao, OD data) throws SQLException {
        if (this.idColumnName == null) {
            throw new SQLException("Object has no id column specified");
        }
        this.addClause(new SimpleComparison(this.idColumnName, this.idFieldType, dataDao.extractId(data), "="));
        return this;
    }

    public Where<T, ID> raw(String rawStatement, ArgumentHolder ... args) {
        for (ArgumentHolder arg : args) {
            String columnName = arg.getColumnName();
            if (columnName == null) {
                if (arg.getSqlType() != null) continue;
                throw new IllegalArgumentException("Either the column name or SqlType must be set on each argument");
            }
            arg.setMetaInfo(this.findColumnFieldType(columnName));
        }
        this.addClause(new Raw(rawStatement, args));
        return this;
    }

    public Where<T, ID> rawComparison(String columnName, String rawOperator, Object value) throws SQLException {
        this.addClause(new SimpleComparison(columnName, this.findColumnFieldType(columnName), value, rawOperator));
        return this;
    }

    public PreparedQuery<T> prepare() throws SQLException {
        return this.statementBuilder.prepareStatement(null);
    }

    public List<T> query() throws SQLException {
        return this.checkQueryBuilderMethod("query()").query();
    }

    public GenericRawResults<String[]> queryRaw() throws SQLException {
        return this.checkQueryBuilderMethod("queryRaw()").queryRaw();
    }

    public T queryForFirst() throws SQLException {
        return this.checkQueryBuilderMethod("queryForFirst()").queryForFirst();
    }

    public String[] queryRawFirst() throws SQLException {
        return this.checkQueryBuilderMethod("queryRawFirst()").queryRawFirst();
    }

    public long countOf() throws SQLException {
        return this.checkQueryBuilderMethod("countOf()").countOf();
    }

    public CloseableIterator<T> iterator() throws SQLException {
        return this.checkQueryBuilderMethod("iterator()").iterator();
    }

    @Deprecated
    public Where<T, ID> clear() {
        return this.reset();
    }

    public Where<T, ID> reset() {
        for (int i = 0; i < this.clauseStackLevel; ++i) {
            this.clauseStack[i] = null;
        }
        this.clauseStackLevel = 0;
        return this;
    }

    public String getStatement() throws SQLException {
        StringBuilder sb = new StringBuilder();
        this.appendSql(null, sb, new ArrayList<ArgumentHolder>());
        return sb.toString();
    }

    void appendSql(String tableName, StringBuilder sb, List<ArgumentHolder> columnArgList) throws SQLException {
        if (this.clauseStackLevel == 0) {
            throw new IllegalStateException("No where clauses defined.  Did you miss a where operation?");
        }
        if (this.clauseStackLevel != 1) {
            throw new IllegalStateException("Both the \"left-hand\" and \"right-hand\" clauses have been defined.  Did you miss an AND or OR?");
        }
        this.peek().appendSql(this.databaseType, tableName, sb, columnArgList);
    }

    public String toString() {
        if (this.clauseStackLevel == 0) {
            return "empty where clause";
        }
        Clause clause = this.peek();
        return "where clause: " + clause;
    }

    private QueryBuilder<T, ID> checkQueryBuilderMethod(String methodName) throws SQLException {
        if (this.statementBuilder instanceof QueryBuilder) {
            return (QueryBuilder)this.statementBuilder;
        }
        throw new SQLException("Cannot call " + methodName + " on a statement of type " + (Object)((Object)this.statementBuilder.getType()));
    }

    private Where<T, ID> in(boolean in, String columnName, Object ... objects) throws SQLException {
        if (objects.length == 1) {
            if (objects[0].getClass().isArray()) {
                throw new IllegalArgumentException("Object argument to " + (in ? "IN" : "notId") + " seems to be an array within an array");
            }
            if (objects[0] instanceof Where) {
                throw new IllegalArgumentException("Object argument to " + (in ? "IN" : "notId") + " seems to be a Where object, did you mean the QueryBuilder?");
            }
            if (objects[0] instanceof PreparedStmt) {
                throw new IllegalArgumentException("Object argument to " + (in ? "IN" : "notId") + " seems to be a prepared statement, did you mean the QueryBuilder?");
            }
        }
        this.addClause(new In(columnName, this.findColumnFieldType(columnName), objects, in));
        return this;
    }

    private Where<T, ID> in(boolean in, String columnName, QueryBuilder<?, ?> subQueryBuilder) throws SQLException {
        if (subQueryBuilder.getSelectColumnCount() != 1) {
            if (subQueryBuilder.getSelectColumnCount() == 0) {
                throw new SQLException("Inner query must have only 1 select column specified instead of *");
            }
            throw new SQLException("Inner query must have only 1 select column specified instead of " + subQueryBuilder.getSelectColumnCount() + ": " + Arrays.toString(subQueryBuilder.getSelectColumns().toArray(new String[0])));
        }
        subQueryBuilder.enableInnerQuery();
        this.addClause(new InSubQuery(columnName, this.findColumnFieldType(columnName), new QueryBuilder.InternalQueryBuilderWrapper(subQueryBuilder), in));
        return this;
    }

    private Clause[] buildClauseArray(Where<T, ID>[] others, String label) {
        Clause[] clauses;
        if (others.length == 0) {
            clauses = null;
        } else {
            clauses = new Clause[others.length];
            for (int i = others.length - 1; i >= 0; --i) {
                clauses[i] = this.pop(label);
            }
        }
        return clauses;
    }

    private void addNeedsFuture(NeedsFutureClause clause) {
        if (this.needsFuture != null) {
            throw new IllegalStateException(this.needsFuture + " is already waiting for a future clause, can't add: " + clause);
        }
        this.needsFuture = clause;
        this.push(clause);
    }

    private void addClause(Clause clause) {
        if (this.needsFuture == null) {
            this.push(clause);
        } else {
            this.needsFuture.setMissingClause(clause);
            this.needsFuture = null;
        }
    }

    private FieldType findColumnFieldType(String columnName) {
        return this.tableInfo.getFieldTypeByColumnName(columnName);
    }

    private void push(Clause clause) {
        if (this.clauseStackLevel == this.clauseStack.length) {
            Clause[] newStack = new Clause[this.clauseStackLevel * 2];
            for (int i = 0; i < this.clauseStackLevel; ++i) {
                newStack[i] = this.clauseStack[i];
                this.clauseStack[i] = null;
            }
            this.clauseStack = newStack;
        }
        this.clauseStack[this.clauseStackLevel++] = clause;
    }

    private Clause pop(String label) {
        if (this.clauseStackLevel == 0) {
            throw new IllegalStateException("Expecting there to be a clause already defined for '" + label + "' operation");
        }
        Clause clause = this.clauseStack[--this.clauseStackLevel];
        this.clauseStack[this.clauseStackLevel] = null;
        return clause;
    }

    private Clause peek() {
        return this.clauseStack[this.clauseStackLevel - 1];
    }
}

