/*
 * Decompiled with CFR 0.152.
 */
package com.j256.ormlite.table;

import com.j256.ormlite.db.DatabaseType;
import com.j256.ormlite.field.DatabaseField;
import com.j256.ormlite.field.DatabaseFieldConfig;
import com.j256.ormlite.field.FieldType;
import com.j256.ormlite.misc.JavaxPersistence;
import com.j256.ormlite.support.ConnectionSource;
import com.j256.ormlite.table.DatabaseTable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class DatabaseTableConfig<T> {
    private Class<T> dataClass;
    private String tableName;
    private List<DatabaseFieldConfig> fieldConfigs;
    private FieldType[] fieldTypes;
    private Constructor<T> constructor;

    public DatabaseTableConfig() {
    }

    public DatabaseTableConfig(Class<T> dataClass, List<DatabaseFieldConfig> fieldConfigs) {
        this(dataClass, DatabaseTableConfig.extractTableName(dataClass), fieldConfigs);
    }

    public DatabaseTableConfig(Class<T> dataClass, String tableName, List<DatabaseFieldConfig> fieldConfigs) {
        this.dataClass = dataClass;
        this.tableName = tableName;
        this.fieldConfigs = fieldConfigs;
    }

    private DatabaseTableConfig(Class<T> dataClass, String tableName, FieldType[] fieldTypes) {
        this.dataClass = dataClass;
        this.tableName = tableName;
        this.fieldTypes = fieldTypes;
    }

    public void initialize() {
        if (this.dataClass == null) {
            throw new IllegalStateException("dataClass was never set on " + this.getClass().getSimpleName());
        }
        if (this.tableName == null) {
            this.tableName = DatabaseTableConfig.extractTableName(this.dataClass);
        }
    }

    public Class<T> getDataClass() {
        return this.dataClass;
    }

    public void setDataClass(Class<T> dataClass) {
        this.dataClass = dataClass;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setFieldConfigs(List<DatabaseFieldConfig> fieldConfigs) {
        this.fieldConfigs = fieldConfigs;
    }

    public void extractFieldTypes(ConnectionSource connectionSource) throws SQLException {
        if (this.fieldTypes == null) {
            this.fieldTypes = this.fieldConfigs == null ? DatabaseTableConfig.extractFieldTypes(connectionSource, this.dataClass, this.tableName) : this.convertFieldConfigs(connectionSource, this.tableName, this.fieldConfigs);
        }
    }

    public FieldType[] getFieldTypes(DatabaseType databaseType) throws SQLException {
        if (this.fieldTypes == null) {
            throw new SQLException("Field types have not been extracted in table config");
        }
        return this.fieldTypes;
    }

    public List<DatabaseFieldConfig> getFieldConfigs() {
        return this.fieldConfigs;
    }

    public Constructor<T> getConstructor() {
        if (this.constructor == null) {
            this.constructor = DatabaseTableConfig.findNoArgConstructor(this.dataClass);
        }
        return this.constructor;
    }

    public void setConstructor(Constructor<T> constructor) {
        this.constructor = constructor;
    }

    public static <T> DatabaseTableConfig<T> fromClass(ConnectionSource connectionSource, Class<T> clazz) throws SQLException {
        String tableName = DatabaseTableConfig.extractTableName(clazz);
        if (connectionSource.getDatabaseType().isEntityNamesMustBeUpCase()) {
            tableName = tableName.toUpperCase();
        }
        return new DatabaseTableConfig<T>(clazz, tableName, DatabaseTableConfig.extractFieldTypes(connectionSource, clazz, tableName));
    }

    public static <T> String extractTableName(Class<T> clazz) {
        DatabaseTable databaseTable = clazz.getAnnotation(DatabaseTable.class);
        String name = null;
        if (databaseTable != null && databaseTable.tableName() != null && databaseTable.tableName().length() > 0) {
            name = databaseTable.tableName();
        } else {
            name = JavaxPersistence.getEntityName(clazz);
            if (name == null) {
                name = clazz.getSimpleName().toLowerCase();
            }
        }
        return name;
    }

    public static <T> Constructor<T> findNoArgConstructor(Class<T> dataClass) {
        Constructor<?>[] constructors;
        try {
            Constructor<?>[] consts;
            constructors = consts = dataClass.getDeclaredConstructors();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Can't lookup declared constructors for " + dataClass, e);
        }
        for (Constructor<?> con : constructors) {
            if (con.getParameterTypes().length != 0) continue;
            if (!con.isAccessible()) {
                try {
                    con.setAccessible(true);
                }
                catch (SecurityException e) {
                    throw new IllegalArgumentException("Could not open access to constructor for " + dataClass);
                }
            }
            return con;
        }
        if (dataClass.getEnclosingClass() == null) {
            throw new IllegalArgumentException("Can't find a no-arg constructor for " + dataClass);
        }
        throw new IllegalArgumentException("Can't find a no-arg constructor for " + dataClass + ".  Missing static on inner class?");
    }

    private static <T> FieldType[] extractFieldTypes(ConnectionSource connectionSource, Class<T> clazz, String tableName) throws SQLException {
        ArrayList<FieldType> fieldTypes = new ArrayList<FieldType>();
        for (Class<T> classWalk = clazz; classWalk != null; classWalk = classWalk.getSuperclass()) {
            for (Field field : classWalk.getDeclaredFields()) {
                FieldType fieldType = FieldType.createFieldType(connectionSource, tableName, field, clazz);
                if (fieldType == null) continue;
                fieldTypes.add(fieldType);
            }
        }
        if (fieldTypes.isEmpty()) {
            throw new IllegalArgumentException("No fields have a " + DatabaseField.class.getSimpleName() + " annotation in " + clazz);
        }
        return fieldTypes.toArray(new FieldType[fieldTypes.size()]);
    }

    private FieldType[] convertFieldConfigs(ConnectionSource connectionSource, String tableName, List<DatabaseFieldConfig> fieldConfigs) throws SQLException {
        ArrayList<FieldType> fieldTypes = new ArrayList<FieldType>();
        for (DatabaseFieldConfig fieldConfig : fieldConfigs) {
            FieldType fieldType = null;
            for (Class<T> classWalk = this.dataClass; classWalk != null; classWalk = classWalk.getSuperclass()) {
                Field field;
                try {
                    field = classWalk.getDeclaredField(fieldConfig.getFieldName());
                }
                catch (NoSuchFieldException e) {
                    continue;
                }
                if (field == null) continue;
                fieldType = new FieldType(connectionSource, tableName, field, fieldConfig, this.dataClass);
                break;
            }
            if (fieldType == null) {
                throw new SQLException("Could not find declared field with name '" + fieldConfig.getFieldName() + "' for " + this.dataClass);
            }
            fieldTypes.add(fieldType);
        }
        if (fieldTypes.isEmpty()) {
            throw new SQLException("No fields were configured for class " + this.dataClass);
        }
        return fieldTypes.toArray(new FieldType[fieldTypes.size()]);
    }
}

