/*
 * Decompiled with CFR 0.152.
 */
package eu.memshare.servlets;

import eu.memshare.Formatters;
import eu.memshare.Utils;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.Date;
import java.util.Vector;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.xml.sax.SAXException;
import ro.atreides.utils.Logger;

public abstract class AbstractServlet
extends HttpServlet {
    protected abstract Object processXml(String var1) throws SAXException;

    protected abstract String generateResponse(Object var1);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter out = null;
        try {
            out = new PrintWriter(new OutputStreamWriter((OutputStream)response.getOutputStream()));
        }
        catch (IllegalStateException e) {
            out = response.getWriter();
        }
        try {
            String filename = this.saveFile(request);
            if (filename == null) {
                this.sendResponse("null message", out);
                return;
            }
            try {
                Object o = this.processXml(filename);
                this.sendResponse(this.generateResponse(o), out);
                boolean deleted = new File(filename).delete();
                if (!deleted) {
                    Logger.logWarning((Object)this, "File not deleted : " + filename);
                }
            }
            catch (SAXException e) {
                e.printStackTrace();
                this.sendResponse("error", out);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            this.sendResponse("cannot write to disk", out);
        }
    }

    protected abstract void doAction(Vector var1);

    private String saveFile(HttpServletRequest request) throws IOException {
        String saveFile = "";
        String contentType = request.getContentType();
        if (contentType != null) {
            DataInputStream in = new DataInputStream((InputStream)request.getInputStream());
            StringBuffer buf = new StringBuffer();
            int charRead = in.read();
            while (charRead > 0) {
                char c = (char)charRead;
                buf.append(c);
                charRead = in.read();
            }
            String content = buf.toString();
            String decoded = URLDecoder.decode(content, "UTF-8");
            decoded = decoded.substring(4, decoded.length());
            String d = Formatters.DATE_TIME_AND_SECONDS_FORMAT.format(new Date());
            String filename = this.getPrefix() + "_" + d + ".xml";
            Utils.writeTextToFile(filename, decoded);
            return filename;
        }
        return null;
    }

    protected abstract String getPrefix();

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    private void sendResponse(String s, PrintWriter out) {
        out.write(s);
        out.flush();
    }
}

