/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.fastagi;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.asteriskjava.fastagi.AbstractMappingStrategy;
import org.asteriskjava.fastagi.AgiRequest;
import org.asteriskjava.fastagi.AgiScript;

public class ResourceBundleMappingStrategy
extends AbstractMappingStrategy {
    private static final String DEFAULT_RESOURCE_BUNDLE_NAME = "fastagi-mapping";
    private String resourceBundleName;
    private Map<String, String> mappings;
    private Map<String, AgiScript> instances;
    private boolean shareInstances;

    public ResourceBundleMappingStrategy() {
        this(DEFAULT_RESOURCE_BUNDLE_NAME);
    }

    public ResourceBundleMappingStrategy(String resourceBundleName) {
        this(resourceBundleName, true);
    }

    public ResourceBundleMappingStrategy(boolean shareInstances) {
        this(DEFAULT_RESOURCE_BUNDLE_NAME, shareInstances);
    }

    public ResourceBundleMappingStrategy(String resourceBundleName, boolean shareInstances) {
        this.resourceBundleName = resourceBundleName;
        this.shareInstances = shareInstances;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setResourceBundleName(String resourceBundleName) {
        this.resourceBundleName = resourceBundleName;
        ResourceBundleMappingStrategy resourceBundleMappingStrategy = this;
        synchronized (resourceBundleMappingStrategy) {
            this.mappings = null;
            this.instances = null;
        }
    }

    public void setShareInstances(boolean shareInstances) {
        this.shareInstances = shareInstances;
    }

    private synchronized void loadResourceBundle() {
        ResourceBundle resourceBundle;
        this.mappings = new HashMap<String, String>();
        if (this.shareInstances) {
            this.instances = new HashMap<String, AgiScript>();
        }
        try {
            resourceBundle = ResourceBundle.getBundle(this.resourceBundleName);
        }
        catch (MissingResourceException e) {
            this.logger.info("Resource bundle '" + this.resourceBundleName + "' not found.");
            return;
        }
        Enumeration<String> keys = resourceBundle.getKeys();
        while (keys.hasMoreElements()) {
            String scriptName = keys.nextElement();
            String className = resourceBundle.getString(scriptName);
            this.mappings.put(scriptName, className);
            if (this.shareInstances) {
                AgiScript agiScript = this.createAgiScriptInstance(className);
                if (agiScript == null) continue;
                this.instances.put(scriptName, agiScript);
            }
            this.logger.info("Added mapping for '" + scriptName + "' to class " + className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AgiScript determineScript(AgiRequest request) {
        ResourceBundleMappingStrategy resourceBundleMappingStrategy = this;
        synchronized (resourceBundleMappingStrategy) {
            if (this.mappings == null || this.shareInstances && this.instances == null) {
                this.loadResourceBundle();
            }
        }
        if (this.shareInstances) {
            return this.instances.get(request.getScript());
        }
        return this.createAgiScriptInstance(this.mappings.get(request.getScript()));
    }
}

