/*
 * Decompiled with CFR 0.152.
 */
package org.asteriskjava.manager;

import java.util.concurrent.atomic.AtomicLong;
import org.asteriskjava.manager.ManagerConnection;
import org.asteriskjava.manager.ManagerConnectionState;
import org.asteriskjava.manager.action.ManagerAction;
import org.asteriskjava.manager.action.PingAction;
import org.asteriskjava.manager.response.ManagerResponse;
import org.asteriskjava.util.Log;
import org.asteriskjava.util.LogFactory;

public class PingThread
extends Thread {
    private static final long DEFAULT_INTERVAL = 20000L;
    private static final AtomicLong idCounter = new AtomicLong(0L);
    private final Log logger = LogFactory.getLog(this.getClass());
    private final long id;
    private long interval = 20000L;
    private long timeout = 0L;
    private boolean die;
    private final ManagerConnection connection;

    public PingThread(ManagerConnection connection) {
        this.connection = connection;
        this.die = false;
        this.id = idCounter.getAndIncrement();
        this.setName("Asterisk-Java Ping-" + this.id);
        this.setDaemon(true);
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void die() {
        this.die = true;
        this.interrupt();
    }

    @Override
    public void run() {
        while (!this.die) {
            try {
                PingThread.sleep(this.interval);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.die) break;
            if (this.connection.getState() != ManagerConnectionState.CONNECTED) continue;
            this.ping();
        }
    }

    protected void ping() {
        try {
            if (this.timeout <= 0L) {
                this.connection.sendAction((ManagerAction)new PingAction(), null);
            } else {
                ManagerResponse response = this.connection.sendAction((ManagerAction)new PingAction(), this.timeout);
                this.logger.debug("Ping response: " + response);
            }
        }
        catch (Exception e) {
            this.logger.warn("Exception on sending Ping", e);
        }
    }
}

