/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.Rectangle;
import java.util.Vector;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.SelectionManager;
import org.tigris.gef.presentation.Fig;

public class CmdAlign
extends Cmd {
    private static final long serialVersionUID = -9169626281664389794L;
    public static final int ALIGN_TOPS = 0;
    public static final int ALIGN_BOTTOMS = 1;
    public static final int ALIGN_LEFTS = 2;
    public static final int ALIGN_RIGHTS = 3;
    public static final int ALIGN_CENTERS = 4;
    public static final int ALIGN_H_CENTERS = 5;
    public static final int ALIGN_V_CENTERS = 6;
    public static final int ALIGN_TO_GRID = 7;
    protected int direction;

    public CmdAlign(int dir) {
        super("Align" + CmdAlign.wordFor(dir));
        this.direction = dir;
    }

    protected static String wordFor(int d) {
        switch (d) {
            case 0: {
                return "Tops";
            }
            case 1: {
                return "Bottoms";
            }
            case 2: {
                return "Lefts";
            }
            case 3: {
                return "Rights";
            }
            case 4: {
                return "Centers";
            }
            case 5: {
                return "HorizontalCenters";
            }
            case 6: {
                return "VerticalCenters";
            }
            case 7: {
                return "ToGrid";
            }
        }
        return "";
    }

    @Override
    public void doIt() {
        int i;
        int size;
        Editor ce = Globals.curEditor();
        Vector figs = (Vector)this.getArg("figs");
        if (figs == null) {
            SelectionManager sm = ce.getSelectionManager();
            if (sm.getLocked()) {
                Globals.showStatus("Cannot Modify Locked Objects");
                return;
            }
            figs = sm.getFigs();
        }
        if ((size = figs.size()) == 0) {
            return;
        }
        Rectangle bbox = ((Fig)figs.elementAt(0)).getBounds();
        for (i = 1; i < size; ++i) {
            bbox.add(((Fig)figs.elementAt(i)).getBounds());
        }
        for (i = 0; i < size; ++i) {
            Fig f = (Fig)figs.elementAt(i);
            f.align(bbox, this.direction, ce);
            f.endTrans();
        }
    }

    @Override
    public void undoIt() {
    }
}

