/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.util.Enumeration;
import java.util.Vector;
import org.tigris.gef.base.Cmd;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Selection;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;

public class CmdCopy
extends Cmd {
    private static final long serialVersionUID = -7316080407001846501L;

    public CmdCopy() {
        super("Copy");
    }

    @Override
    public void doIt() {
        Editor ce = Globals.curEditor();
        Vector copiedElements = ce.getSelectionManager().selections();
        Vector<Fig> figs = new Vector<Fig>();
        Enumeration copies = copiedElements.elements();
        while (copies.hasMoreElements()) {
            Selection s = (Selection)copies.nextElement();
            Fig f = s.getContent();
            if (f instanceof FigEdge) continue;
            f = (Fig)f.clone();
            figs.addElement(f);
        }
        Globals.clipBoard = figs;
    }

    @Override
    public void undoIt() {
        System.out.println("Undo does not make sense for CmdCopy");
    }

    static class SimpleSelection
    implements Transferable,
    ClipboardOwner {
        protected Fig selection;
        protected DataFlavor flavor;

        public SimpleSelection(Fig selection, DataFlavor flavor) {
            this.selection = selection;
            this.flavor = flavor;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{this.flavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor f) {
            return f.equals(this.flavor);
        }

        @Override
        public Object getTransferData(DataFlavor f) throws UnsupportedFlavorException {
            if (f.equals(this.flavor)) {
                return this.selection;
            }
            throw new UnsupportedFlavorException(f);
        }

        @Override
        public void lostOwnership(Clipboard c, Transferable t) {
            this.selection = null;
        }
    }
}

