/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import Acme.JPM.Encoders.GifEncoder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.OutputStream;
import org.tigris.gef.base.CmdSaveGraphics;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.TransFilter;

public class CmdSaveGIF
extends CmdSaveGraphics {
    private static final long serialVersionUID = 4044142753088912626L;
    public static final int TRANSPARENT_BG_COLOR = 0xEFEFEF;

    public CmdSaveGIF() {
        super("SaveGIF");
    }

    @Override
    protected void saveGraphics(OutputStream s, Editor ce, Rectangle drawingArea) throws IOException {
        Image i = ce.createImage(drawingArea.width * this.scale, drawingArea.height * this.scale);
        Graphics g = i.getGraphics();
        if (g instanceof Graphics2D) {
            ((Graphics2D)g).scale(this.scale, this.scale);
        }
        g.setColor(new Color(0xEFEFEF));
        g.fillRect(0, 0, drawingArea.width * this.scale, drawingArea.height * this.scale);
        g.translate(-drawingArea.x, -drawingArea.y);
        ce.print(g);
        try {
            FilteredImageSource fis = new FilteredImageSource(i.getSource(), new TransFilter(0xEFEFEF));
            GifEncoder ge = new GifEncoder((ImageProducer)fis, s);
            ge.encode();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        g.dispose();
        g = null;
        i = null;
    }
}

