/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import org.tigris.gef.base.LayerPerspective;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigNode;

public class LayerPerspectiveMutable
extends LayerPerspective {
    private static final long serialVersionUID = 4692683431762315041L;
    private MutableGraphModel mutableGraphModel;

    public LayerPerspectiveMutable(String name, MutableGraphModel mgm) {
        super(name, mgm);
        this.mutableGraphModel = mgm;
    }

    @Override
    public GraphModel getGraphModel() {
        return this.getMutableGraphModel();
    }

    @Override
    public void setGraphModel(GraphModel gm) {
        this.setMutableGraphModel((MutableGraphModel)gm);
    }

    public MutableGraphModel getMutableGraphModel() {
        return this.mutableGraphModel;
    }

    public void setMutableGraphModel(MutableGraphModel mgm) {
        super.setGraphModel(mgm);
        this.mutableGraphModel = mgm;
    }

    @Override
    public void add(Fig fig) {
        Object owner = fig.getOwner();
        if (fig instanceof FigNode && this.contains(fig) && this.mutableGraphModel.containsNode(owner) && fig.getLayer() == this) {
            return;
        }
        super.add(fig);
    }

    @Override
    public void remove(Fig f) {
        super.remove(f);
        Object owner = f.getOwner();
        if (owner != null) {
            if (f instanceof FigEdge && this.mutableGraphModel.containsEdge(owner)) {
                this.mutableGraphModel.removeEdge(owner);
            } else if (f instanceof FigNode && this.mutableGraphModel.containsNode(owner)) {
                this.mutableGraphModel.removeNode(owner);
            }
        }
    }
}

