/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.gef.base;

import java.awt.event.MouseEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.gef.base.Editor;
import org.tigris.gef.base.Globals;
import org.tigris.gef.base.Layer;
import org.tigris.gef.base.ModeCreate;
import org.tigris.gef.graph.GraphModel;
import org.tigris.gef.graph.MutableGraphModel;
import org.tigris.gef.presentation.Fig;
import org.tigris.gef.presentation.FigEdge;
import org.tigris.gef.presentation.FigLine;
import org.tigris.gef.presentation.FigNode;
import org.tigris.gef.undo.Memento;
import org.tigris.gef.undo.UndoManager;

public class ModeCreateEdge
extends ModeCreate {
    private static final long serialVersionUID = -3551773848229016093L;
    private Object startPort;
    private Fig _startPortFig;
    private FigNode _sourceFigNode;
    private Object _newEdge;
    private static Log LOG = LogFactory.getLog(ModeCreateEdge.class);

    public ModeCreateEdge() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Created ModeCreateEdge");
        }
    }

    public ModeCreateEdge(Editor par) {
        super(par);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Created ModeCreateEdge for Editor");
        }
    }

    @Override
    public String instructions() {
        return "Drag to define an edge to another port";
    }

    @Override
    public Fig createNewItem(MouseEvent me, int snapX, int snapY) {
        return new FigLine(snapX, snapY, 0, 0, Globals.getPrefs().getRubberbandColor());
    }

    @Override
    public void mousePressed(MouseEvent me) {
        if (me.isConsumed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed but rejected as already consumed");
            }
            return;
        }
        UndoManager.getInstance().addMementoLock(this);
        int x = me.getX();
        int y = me.getY();
        Editor ce = Globals.curEditor();
        Fig underMouse = ce.hit(x, y);
        if (underMouse == null) {
            underMouse = ce.hit(x - 16, y - 16, 32, 32);
        }
        if (underMouse == null) {
            this.done();
            me.consume();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed but nothing under - consumed");
            }
            return;
        }
        if (!(underMouse instanceof FigNode)) {
            this.done();
            me.consume();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed but not a FigNode under - consumed");
            }
            return;
        }
        this._sourceFigNode = (FigNode)underMouse;
        this.startPort = this._sourceFigNode.deepHitPort(x, y);
        if (this.startPort == null) {
            this.done();
            me.consume();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MousePressed but no port found - consumed");
            }
            return;
        }
        this._startPortFig = this._sourceFigNode.getPortFig(this.startPort);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"MousePressed start port set");
        }
        super.mousePressed(me);
    }

    @Override
    public void mouseReleased(MouseEvent me) {
        GraphModel gm;
        if (me.isConsumed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MouseReleased but rejected as already consumed");
            }
            return;
        }
        if (this._sourceFigNode == null) {
            this.done();
            me.consume();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"MouseReleased but no source found so consuming and leaving");
            }
            return;
        }
        UndoManager.getInstance().startChain();
        int x = me.getX();
        int y = me.getY();
        Editor ce = Globals.curEditor();
        Fig f = ce.hit(x, y);
        if (f == null) {
            f = ce.hit(x - 16, y - 16, 32, 32);
        }
        if (!((gm = ce.getGraphModel()) instanceof MutableGraphModel)) {
            f = null;
        }
        if (f instanceof FigNode) {
            MutableGraphModel mgm = (MutableGraphModel)gm;
            FigNode destFigNode = (FigNode)f;
            Object foundPort = destFigNode.deepHitPort(x, y);
            if (foundPort != null && mgm.canConnect(this.startPort, foundPort)) {
                Fig destPortFig = destFigNode.getPortFig(foundPort);
                Class edgeClass = (Class)this.getArg("edgeClass");
                this._newEdge = edgeClass != null ? mgm.connect(this.startPort, foundPort, edgeClass) : mgm.connect(this.startPort, foundPort);
                if (null != this._newEdge) {
                    ce.damageAll();
                    this._sourceFigNode.damage();
                    destFigNode.damage();
                    this._newItem = null;
                    Layer layer = ce.getLayerManager().getActiveLayer();
                    FigEdge fe = (FigEdge)layer.presentationFor(this._newEdge);
                    fe.setSourcePortFig(this._startPortFig);
                    fe.setSourceFigNode(this._sourceFigNode);
                    fe.setDestPortFig(destPortFig);
                    fe.setDestFigNode(destFigNode);
                    this.endAttached(fe);
                    if (fe != null) {
                        ce.getSelectionManager().select(fe);
                    }
                    this.done();
                    me.consume();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"MouseReleased Edge created and event consumed");
                    }
                    return;
                }
            }
        }
        this._sourceFigNode.damage();
        ce.damageAll();
        this._newItem = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"MouseReleased not on FigNode. Event consumed anyway.");
        }
        this.done();
        me.consume();
    }

    protected Object getStartPort() {
        return this.startPort;
    }

    protected void endAttached(FigEdge fe) {
        UndoManager.getInstance().removeMementoLock(this);
        if (UndoManager.getInstance().isGenerateMementos()) {
            UndoManager.getInstance().addMemento(new CreateEdgeMemento(this.editor, this._newEdge, fe));
        }
        UndoManager.getInstance().addMementoLock(this);
    }

    class CreateEdgeMemento
    extends Memento {
        private FigEdge edgePlaced;
        private Object edge;
        private Editor editor;

        CreateEdgeMemento(Editor ed, Object edge, FigEdge edgePlaced) {
            this.edgePlaced = edgePlaced;
            this.edge = edge;
            this.editor = ed;
        }

        @Override
        public void undo() {
            UndoManager.getInstance().addMementoLock(this);
            this.editor.getSelectionManager().deselect(this.edgePlaced);
            if (this.edge != null) {
                ((MutableGraphModel)this.editor.getGraphModel()).removeEdge(this.edge);
            }
            this.editor.remove(this.edgePlaced);
            UndoManager.getInstance().removeMementoLock(this);
        }

        @Override
        public void redo() {
            UndoManager.getInstance().addMementoLock(this);
            this.editor.add(this.edgePlaced);
            GraphModel gm = this.editor.getGraphModel();
            if (this.edge != null) {
                ((MutableGraphModel)gm).addEdge(this.edge);
            }
            this.editor.getSelectionManager().select(this.edgePlaced);
            UndoManager.getInstance().removeMementoLock(this);
        }

        @Override
        public void dispose() {
        }

        @Override
        public String toString() {
            return (this.isStartChain() ? "*" : " ") + "PlaceMemento " + this.edgePlaced.getBounds();
        }
    }
}

